# Memory Data Standards

## Overview

This document defines what should and should NOT be stored in long-term memory systems.

---

## ✅ Allowed Content

### 1. User Preferences / Identity / Long-Term Goals
- User name, pronouns, timezone
- Communication preferences (language, channel)
- Long-term projects and goals
- Personal values and priorities

**Example:**
```
User: Alex
Timezone: UTC+8
Preferred: PDF output, Telegram delivery
Projects: Research analysis, daily briefs
```

### 2. Confirmed Important Conclusions
- Decisions made and confirmed by user
- Established facts and findings
- Important lessons learned
- Verified information

**Example:**
```
OneDrive sync: Local folder "octavius_museum" maps to root
Strike reporting: Always include next 5 days
```

### 3. System-Level Settings and Rules
- Architecture decisions
- Token safety rules
- Agent behaviors and constraints
- Operational procedures

**Example:**
```
Memory injection: Two-phase only, no full load
Token budget: Safety margin at 85%
Safety valve: Memory is expendable
```

---

## ❌ Forbidden Content

### 1. Raw Conversation Logs
- Exact copies of chat messages
- Unprocessed dialogue history
- Conversation transcripts

**Why:** Can be recovered from chat history; takes up token space.

### 2. Reasoning Traces
- Internal monologue or thought process
- Hypothesis and testing steps
- Debugging attempts
- "Mental notes" not finalized

**Why:** Only relevant during the conversation; not reusable.

### 3. Temporary Discussions
- On-going debates
- Incomplete decisions
- Draft ideas not yet confirmed
- Exploratory conversations

**Why:** May change; not confirmed facts.

### 4. Recoverable Information
- Information that exists elsewhere (docs, files)
- Data that can be retrieved from tools
- Duplicate information
- Time-sensitive content (dates, events)

**Why:** Duplication wastes tokens; may become outdated.

---

## Memory Quality Checklist

Before storing in long-term memory, ask:

1. ☐ Is this a reusable fact? (not conversation)
2. ☐ Has the user confirmed this? (not draft)
3. ☐ Is this not recoverable elsewhere?
4. ☐ Is this stable over time? (not time-sensitive)
5. ☐ Does this justify token cost?

If all yes → Store in long-term memory.
If any no → Discard or keep in session only.
