---
name: promotion-review
description: Analyze promotion/review materials (述职/晋升材料) as an evaluator, identify issues and likely interview questions, then provide coaching advice. Supports text files, PDFs, and images (screenshots). Default output is Markdown file; HTML with Cloudflare R2 upload is optional. Use when user sends promotion documents, review materials, 述职材料, 晋升材料, or asks to review/analyze career advancement documents.
---

# Promotion Review Skill

分析晋升/述职材料，以评委视角诊断问题，生成辅导报告。

---

## 🎯 核心方法论

### 职级跃迁的本质

| 级别 | 画像 | 核心能力 |
|------|------|----------|
| P7 | 超级执行者 | 能把事做好、做完、做漂亮 |
| P8 | 技术决策者 | 能判断什么是对的、推动团队采纳、承担决策后果 |
| P9 | 技术方向引领者 | 能定义问题、开辟新方向、影响组织 |

**核心认知**：晋升材料要展示的不是"我做了多少事"，而是"我做了什么别人做不了的判断和决策"。

### 叙事升维公式

```
P7 写法：我做了 X，结果是 Y
P8 写法：我判断 A 是正确方向，推动团队采纳，克服了 B 阻力，最终实现 Y
```

### 决策故事结构（STAR-D）

每个核心贡献都应该能用这个结构讲清楚：

```
背景（Situation）：当时的问题/挑战是什么
方案对比（Alternatives）：考虑过哪些方案（至少2个）
我的判断（Decision）：为什么选这个方案，理由是什么
推动过程（Action）：有什么阻力，怎么推动的
结果验证（Result）：数据证明决策是对的
```

### 数据加固三问法

每个关键数据都要能回答：

| 问题 | 说明 | 示例 |
|------|------|------|
| **怎么测的？** | 测算方法 | "对比2024Q3和2025Q1同类型需求47个" |
| **对比谁？** | 基线/对照组 | "AI工作流上线前 vs 上线后" |
| **是你的功劳吗？** | 归因逻辑 | "排除了人员变动、需求复杂度等因素" |

**反例**：
- ❌ "效率提升 20~30%" — 范围太宽，不够精确
- ❌ "60%+" — 到底是多少？
- ❌ "大幅提升" — 没有数字

**正例**：
- ✅ "交付周期从5.2天降至3.9天，提升25%（基于47个可比需求）"

---

## 📊 分析框架（评委视角）

根据**目标职级**校准评判标准。

### 🔴 致命问题（Critical Issues）

- **个人 vs 团队边界** — "我"和"我们"是否清晰？
- **技术深度** — 是否匹配目标职级？
- **角色定位** — "主导"、"参与"、"接盘"是否可信？
- **叙事层级** — 读起来像 N+1 还是 N+？
- **决策能力** — 有没有体现"为什么这样做"而不只是"做了什么"

### 🟡 中等问题（Medium Issues）

- **数据归因** — 有基线吗？有对照组吗？怎么测的？
- **荣誉堆砌** — 质量 vs 数量，和目标职级的关联
- **未来规划** — 具体可衡量 vs 空泛愿景
- **架构图** — 解释了"为什么"还是只画了"是什么"
- **范围膨胀** — 声称的广度有没有深度支撑
- **时间线可信度** — 短任期 + 大成果 = 红旗
- **术语解释** — 内部术语首次出现是否有解释

### 🟢 次要问题（Minor Issues）

- 格式、错别字、遗留的 TODO
- 数据前后不一致
- 标题不通顺

---

## ⏱️ 答辩时间分配方法论

### 材料 vs 答辩的区别

| 维度 | 材料 | 答辩 |
|------|------|------|
| 目的 | 评委提前阅读，了解全貌 | 让评委记住你的亮点 |
| 详略 | 可以详细，面面俱到 | 必须精简，突出重点 |
| 数据 | 可以堆数据 | 只讲3-5个核心数据 |
| 贡献 | 三个都要写清楚 | 重点讲1个，其他带过 |
| 风格 | 书面语，可以复杂 | 口语化，易于理解 |

**关键认知**：材料是"菜单"，答辩是"招牌菜"。

### 8分钟答辩的"1主2辅"策略

**问题**：三个贡献各讲2分钟 → 都讲不深 → 评委记不住

**策略**：
- **主贡献**（3-4分钟）：讲透，展示技术决策能力
- **辅贡献1**（1-1.5分钟）：带过，强调结果
- **辅贡献2**（0.5-1分钟）：点到即止，为追问留空间

### 建议时间分配（8分钟）

| 环节 | 时间 | 内容 |
|------|------|------|
| 开场定位 | 45秒 | 我是谁 + 一句话定位（用数据说话） |
| 核心贡献 | 5分30秒 | 1主2辅，重点讲决策过程 |
| 未来规划 | 45秒 | 具体可量化的目标 |
| 收尾金句 | 30秒 | 为什么我够这个级别 |
| 缓冲 | 30秒 | 防止超时 |

### 主贡献选择标准

选择做主贡献的项目应该满足：
1. 时间跨度长（更可信）
2. 有完整方法论（可复制）
3. 数据可追溯（防追问）
4. 最能体现目标级别的核心能力

### 答辩话术技巧

**开场不要念简历**：
- ❌ "我是XX，2023年加入，负责..."
- ✅ "我用两年把XX从0做到XX%"

**用"我判断/我决策"句式**：
- ❌ "我们团队做了..."
- ✅ "我设计了...因为..."

**数据要有对比**：
- ❌ "可用率46%"
- ✅ "可用率从10%提升到46%"

**结尾要有力**：
- ❌ "以上就是我的汇报，谢谢"
- ✅ "我准备好了，谢谢各位评委"

---

## 📥 支持的输入格式

| 格式 | 说明 |
|------|------|
| **文本文件** | TXT, MD — 直接读取 |
| **PDF** | 用 `pdftotext` 提取 |
| **DOCX** | 用 `python-docx` 提取 |
| **图片** | PNG, JPG — 可接受，但需提醒用户 |

### ⚠️ 图片输入注意事项

图片（尤其是长截图）识别可能存在模糊：
- 超长截图会被压缩显示，小字可能看不清
- 架构图里的小标签文字可能识别不准
- **建议用户**：如有原始文档优先发文件，或分段截图提高清晰度

如果基于图片分析，在报告中注明：
> ⚠️ 本分析基于截图识别，部分细节可能有误差，建议对照原文确认。

---

## 🔄 工作流程

### 1. 获取材料

- 检查 Discord 消息附件（PDF, TXT, DOCX, 图片）
- 下载并提取文本
- 如无附件，请用户提供文件路径或直接粘贴内容

### 2. 收集上下文

分析前确认（如未提供则询问）：
- 目标职级（如 P7→P8, T7→T8）
- 公司/体系（如京东、阿里、字节）
- 用户特别关注的问题
- **是否为迭代版本**（首次分析 or 二次分析）
- **答辩时间**（如有，提供时间分配建议）

### 3. 首次分析 vs 二次分析

#### 首次分析（Initial Review）

完整分析，包括：
- 评委视角诊断
- 评审追问预测
- 辅导建议
- 改写方向

#### 二次分析（Iterative Review）

对比新旧版本，重点关注：

**📊 改进点识别**
- 新版本修复了哪些之前指出的问题
- 数据是否更具体、归因是否更清晰
- 叙事结构是否有改善

**⚠️ 仍存在的问题**
- 哪些核心问题没有解决
- 是否产生了新问题
- 评委仍然会追问什么

**🎯 下一步建议**
- 优先级排序：最该改的 1-2 点
- 具体改写方向（不是替用户写，而是指明方向）

---

## ❓ 评审追问预测

生成 8-12 个可能被问到的问题，分类为：

| 类型 | 说明 |
|------|------|
| **必问** | 核心数据、关键主张、角色边界 |
| **高概率** | 深度探测、未来愿景、方案对比 |

每个问题包含：
- 问题文本
- 为什么会问（评委在测试什么）
- 建议准备的答辩口径

---

## ✏️ 辅导建议（教练视角）

切换到教练角色，针对每个关键/中等问题：

1. **叙事重构** — 一句话概括需要的转变
2. **改写方向** — 用 STAR-D 结构指明应该强调什么
3. **数据加固** — 用三问法让数字"防追问"
4. **决策故事** — 建议 2-3 个"背景→方案对比→判断→结果"的故事
5. **结构调整** — 建议的大纲和重点标记

---

## 📤 输出格式

### 默认：Markdown 文件 ✅

生成结构化的 Markdown 报告，保存到 workspace：

```
<候选人>-<职级>晋升材料-辅导建议-v<版本>.md
<候选人>-<职级>答辩-时间分配建议.md（如有答辩时间要求）
<候选人>-<职级>晋升材料-评委视角问题清单-v<版本>.md（二次分析）
```

通过 Discord 文件发送给用户。

### 可选：HTML + R2 上传

用户明确要求时，额外生成 HTML 报告并上传到 Cloudflare R2。

**注意**：R2 链接公开可访问，有一定泄露风险，提醒用户注意隐私。

---

## 📁 模板文件

| 文件 | 用途 |
|------|------|
| `assets/template.md` | 首次分析 Markdown 模板（完整版） |
| `assets/template-iterative.md` | 二次分析 Markdown 模板（精简版） |
| `assets/template.html` | HTML 报告模板（可选，用于 R2 上传）|

使用时复制模板，替换 `{{PLACEHOLDER}}` 占位符。

---

## 🔒 隐私提醒

- 材料包含真实姓名和职业信息 — 不要在会话外缓存或记录
- 默认 Markdown 输出更安全（本地文件）
- R2 链接公开可访问，使用前提醒用户
- 报告中不暴露辅导者身份（匿名反馈）
