---
name: project-management
description: Manage projects, tasks, and priorities effectively as a solopreneur. Use when organizing work, tracking progress, managing deadlines, coordinating with contractors or clients, or building project management systems. Covers task management methods, prioritization frameworks, project planning templates, tool selection, and personal productivity workflows. Trigger on "project management", "manage my work", "organize tasks", "project planning", "task management", "prioritization", "stay organized".
---

# Project Management

## Overview
As a solopreneur, you are the project manager by default. Without structure, tasks pile up, deadlines get missed, and progress stalls. This playbook gives you lightweight project management systems that keep you organized and moving forward — without the overhead of enterprise PM tools and processes.

---

## Step 1: Choose Your Task Management System

You need one source of truth for all work. Pick a system that fits your workflow.

**System comparison:**

| System | Best For | Complexity | Cost |
|---|---|---|---|
| **Pen + Paper / Bullet Journal** | Analog lovers, very simple workflows | Very Low | $5 (notebook) |
| **Todo list app (Todoist, Things)** | Personal tasks, simple workflows | Low | Free-$5/mo |
| **Kanban board (Trello, Notion)** | Visual thinkers, multi-stage workflows | Low-Medium | Free-$10/mo |
| **Project tool (Asana, ClickUp, Notion)** | Multiple projects, client work, collaboration | Medium-High | Free-$20/mo |
| **Spreadsheet (Google Sheets, Airtable)** | Custom workflows, data-driven tracking | Medium | Free |

**Selection criteria:**
- Just you? → Todoist or Notion
- Working with contractors or clients? → Asana or Trello (easy to share)
- Multiple concurrent projects? → Notion or ClickUp (databases + views)
- Like to customize everything? → Airtable or Notion

**Recommendation:** Start simple (Todoist or Trello). Add complexity only when simple stops working.

---

## Step 2: Organize Work into Projects and Tasks

**Hierarchy:**
```
AREA (broad life/business domain)
  ↓
PROJECT (has a defined end state)
  ↓
TASK (single action, completable in one session)
  ↓
SUBTASK (optional, breaks task into smaller steps)
```

**Example:**
```
AREA: Marketing
  PROJECT: Launch email nurture sequence
    TASK: Write 5 emails for sequence
      SUBTASK: Draft email 1
      SUBTASK: Draft email 2
      [...]
    TASK: Design email templates in tool
    TASK: Set up automation triggers
    TASK: Test sequence with dummy contact
```

**Project definition rules:**
- A project has a clear done state: "Launch email nurture sequence" → done = sequence is live
- A task is a single action: "Write email 1" not "Write all the emails"
- If a task feels overwhelming, break it into subtasks

**Active project limit:** As a solopreneur, keep 3-5 active projects max. More than that and progress stalls on everything.

---

## Step 3: Prioritize Using Eisenhower Matrix

Not all tasks are equal. Use the Eisenhower Matrix to decide what to do now, later, delegate, or delete.

**The Matrix:**

```
                Urgent
           |               |
Important  | DO FIRST (Q1) | SCHEDULE (Q2)
           |               |
-----------|---------------|------------------
           | DELEGATE (Q3) | DELETE (Q4)
Not        |               |
Important  |               |
```

**Quadrants:**
- **Q1 (Urgent + Important):** Crises, deadlines, critical bugs → Do immediately
- **Q2 (Not Urgent + Important):** Strategic work, planning, skill-building → Schedule time for this (most valuable work)
- **Q3 (Urgent + Not Important):** Interruptions, low-value requests → Delegate or decline
- **Q4 (Not Urgent + Not Important):** Busy work, distractions → Delete

**How to use:**
1. Every morning, categorize your task list into Q1-Q4
2. Do Q1 tasks first (if any)
3. Block time for Q2 tasks (this is where growth happens)
4. Minimize Q3 (say no, automate, or batch it)
5. Delete Q4 entirely

**Most solopreneurs over-invest in Q1 and Q3, under-invest in Q2.** Strategic work (Q2) is what scales your business. Protect time for it.

---

## Step 4: Plan Your Week (Sunday or Monday Planning Ritual)

Weekly planning keeps you aligned with goals and prevents reactive firefighting.

**Weekly planning template (15-30 min):**

### Part 1: Review Last Week
- [ ] What got done? (celebrate wins)
- [ ] What didn't get done? (why not? reschedule or delete?)
- [ ] Any blockers or issues to address?

### Part 2: Set This Week's Top 3 Priorities
Pick 3 most important outcomes for the week. Not tasks — outcomes.

Bad: "Work on marketing"
Good: "Publish 2 blog posts and schedule 5 social posts"

### Part 3: Time Block the Big Rocks
For each priority, block specific time on your calendar.

Example:
```
Monday 9-11am: Draft blog post 1
Tuesday 9-11am: Draft blog post 2
Wednesday 2-4pm: Edit both posts, schedule social posts
```

### Part 4: Brain Dump and Organize
List everything else that needs attention this week. Categorize into:
- This week (must happen)
- Next week (can wait)
- Someday (no urgency)

**Rule:** If it's not scheduled, it won't happen. Protect time for your top 3 priorities FIRST, then fit other work around them.

---

## Step 5: Manage Daily Work (Daily Planning Ritual)

Start each day with a 5-10 min planning session.

**Daily planning template:**

1. **Check calendar:** What's scheduled today? (meetings, calls, deadlines)
2. **Review weekly priorities:** What's the most important thing to move forward today?
3. **Pick 1-3 tasks:** Choose the top 1-3 tasks for today. More than 3 and you're setting yourself up to fail.
4. **Time block tasks:** Assign each task to a specific time slot

**Daily task list structure:**
```
TODAY'S TOP PRIORITY: [The one task that must get done]
  Time: [When you'll do it]

SECONDARY TASKS:
  - [Task 2] — Time: [When]
  - [Task 3] — Time: [When]

IF TIME PERMITS:
  - [Nice-to-have task]
  - [Low-priority task]
```

**End-of-day ritual (5 min):**
- Mark completed tasks done (dopamine hit + clear visibility)
- Move incomplete tasks to tomorrow or later
- Note any blockers or wins

---

## Step 6: Manage Projects with Multiple Phases

For larger projects (2+ weeks), break them into phases to maintain progress visibility.

**Project planning template:**

```
PROJECT: [Name]
GOAL: [What does success look like?]
DEADLINE: [Target completion date]
OWNER: [You, or if delegated, who]

PHASES:
  Phase 1: [Name] (Target: Week 1)
    - Task 1
    - Task 2
    - Task 3

  Phase 2: [Name] (Target: Week 2)
    - Task 4
    - Task 5

  Phase 3: [Name] (Target: Week 3)
    - Task 6
    - Task 7

STATUS: [Not Started / In Progress / Blocked / Done]
BLOCKERS: [What's preventing progress?]
NOTES: [Context, links, decisions]
```

**Weekly project check-in:**
- Which phase are you in?
- On track for deadline?
- Any blockers? (if yes, escalate or solve)

---

## Step 7: Manage Client Projects or Deliverables

When working with clients or contractors, visibility and communication are critical.

**Client project board structure (use Trello or Notion):**

```
COLUMNS:
  - Backlog (tasks not started)
  - In Progress (you're actively working on it)
  - Review (waiting for client feedback)
  - Done (completed and approved)

CARD STRUCTURE (per task):
  - Title: [Deliverable name]
  - Due date: [When]
  - Assigned to: [You or contractor]
  - Description: [What needs to be delivered]
  - Attachments: [Files, links, references]
  - Checklist: [Sub-steps]
  - Comments: [Client feedback, notes]
```

**Client communication rules:**
- Update project status weekly (send a brief email or share the board link)
- Move tasks to "Review" column when ready for client feedback
- Never let a task sit in "Review" for more than 3 days without following up

---

## Step 8: Track Progress and Reflect

Project management isn't just about task lists. It's about learning and improving over time.

**Monthly review (30 min):**
- [ ] How many projects did you complete this month?
- [ ] What percentage of weekly priorities got done? (aiming for 70-80%)
- [ ] What took longer than expected? (why?)
- [ ] What tools or workflows slowed you down? (fix them)
- [ ] What should you stop doing? (low-value work, distractions)
- [ ] What should you start doing? (delegation, automation, new systems)

**Key metrics to track (optional but valuable):**
- Tasks completed per week (see trends over time)
- Time spent on Q2 work (strategic) vs Q1 work (reactive)
- Projects completed per quarter
- Percentage of deadlines met

**Rule:** If you're consistently missing deadlines or priorities, the system isn't working. Simplify or adjust.

---

## Project Management Mistakes to Avoid
- **No single source of truth.** Tasks in email, notebook, Slack, and your head = chaos. Pick ONE system and use only that.
- **Overly complex systems.** If your PM tool requires 15 minutes of admin per day, it's too complex. Keep it simple.
- **No weekly planning.** Reactive solopreneurs stay busy but make little progress. Weekly planning ensures you focus on what matters.
- **Too many active projects.** 10 active projects = 0 completed projects. Limit to 3-5 max.
- **Not breaking big tasks into smaller ones.** "Launch product" feels overwhelming and never gets done. "Write landing page copy" is actionable.
- **Not saying no.** Every yes is a no to something else. Protect your priorities ruthlessly.
