# 子代理任务模板

> 用于 L3/L2/L1 文档生成的标准子代理任务模板

---

## L3 文档生成模板

```markdown
# 任务：为 <模块名> 模块生成 L3 文档（分片 X/Y）

## 源码路径
<绝对路径，如：E:\projects\infypower-energy-ai\energy-ai-api\src\main\java\com\infypower\ai\advisor\>

## 输出路径
D:\ai\workspace\docs\<项目名>\<模块名>\

## 本分片文件（<10-15 个>）
<列出具体文件路径或目录>

## 要求
1. 为每个文件生成 L3 文档 (*.java.md)
2. 简单文件 (<50 行纯定义/枚举/接口) → 简化文档（基本信息 + 职责）
3. 复杂文件 → 完整 L3 文档（函数签名、调用关系、关键逻辑行号）
4. **严格上下文压缩**：每处理完 2-3 个文件，压缩已处理内容的完整描述，只保留路径 +1 行摘要
5. 超时前（5 分钟）尽可能完成更多文件
6. 完成后返回 JSON 摘要

## L3 文档模板
参考 templates/l3-template.md

## 返回格式
```json
{
  "module": "<模块名>",
  "chunk": "X/Y",
  "status": "completed|partial",
  "processed": ["File1.java", "File2.java"],
  "pending": ["File3.java"],
  "summaries": [
    {"file": "File1.java", "lines": 150, "type": "complex", "summary": "一句话摘要"}
  ]
}
```

开始执行！
```

---

## L2 文档生成模板

```markdown
# 任务：为 <模块名> 模块生成 L2 文档

## 输入
读取 D:\ai\workspace\docs\<项目名>\<模块名>\ 目录下所有 L3 文档

## 输出
D:\ai\workspace\docs\<项目名>\<模块名>.md

## 要求
1. 读取所有 L3 文档的摘要信息（文件名、行数、类型、职责）
2. 生成 L2 模块级文档，包含：
   - 模块职责概述（200 字）
   - 文件索引表（文件路径 | 职责简述 | 复杂度 | 行数）
   - 公共 API（核心类、核心方法）
   - 依赖关系图（ASCII 或 Markdown 表格）
   - 核心流程（1-3 个关键业务流程）
   - 配置项（如有）
3. **上下文压缩**：读取 L3 时只提取关键信息，不保留完整文档内容
4. 文档大小控制在 5-15KB

## L2 文档模板
参考 templates/l2-template.md

开始执行！
```

---

## L1 文档生成模板

```markdown
# 任务：生成 <项目名> 的 L1 项目级文档

## 输入
读取以下 L2 模块级文档：
<列出所有 module.md 路径>

## 输出
D:\ai\workspace\docs\<项目名>\project.md

## 要求
生成 L1 项目级文档，包含：
1. **项目基本信息** - 名称、技术栈、架构模式、数据库、中间件
2. **核心模块索引表** - 模块名 | 职责 | 文档路径 | 文件数 | 关键词
3. **系统架构图** - 模块间依赖关系（ASCII 或 Mermaid）
4. **目录结构** - 完整的工程目录树
5. **核心流程** - 跨模块的核心业务流程（2-4 个）
6. **技术栈汇总** - 框架、中间件、数据库
7. **配置项汇总** - 全局配置
8. **文档覆盖状态** - L3 文档统计

## L1 文档模板
参考 templates/l1-template.md

开始执行！
```

---

## 上下文压缩提醒模板

在子代理任务中添加此提醒：

```markdown
## ⚠️ 上下文压缩要求

**严格遵循以下压缩策略**:

1. **每处理 2-3 个文件后**:
   - 保留：文件路径列表 + 1 行摘要/文件
   - 丢弃：已生成文档的完整内容、中间思考过程

2. **上下文使用率监控**:
   - 40%: 准备压缩
   - 50%: **强制压缩**
   - 60%: 停止并报告

3. **压缩示例**:
   ```
   压缩前：File1.java 完整文档内容 (2000 字...)
   压缩后：File1.java - 服务层基类，150 行，复杂
   ```

开始执行前，请确认你理解上下文压缩要求！
```

---

## 超时处理模板

```markdown
## ⏱️ 超时处理

- **超时时间**: 300 秒（5 分钟）
- **超时前策略**: 优先完成核心文件，简化文档内容
- **超时后处理**: 
  1. 记录已完成文件
  2. 返回进度报告
  3. 等待重新分片

如果预计无法在超时前完成，请提前报告进度！
```

---

*本文档为 project-analyzer-generate-doc skill 的参考模板*
