# Professional Communication

Write clear, effective professional messages that get read and acted upon. Routes you to ready-to-use templates and translation guides for professional technical communication.

## What's Inside

- Quick reference message structure (key message first, scannable format, clear action)
- The Four Rules (subject lines, bullets over paragraphs, specific asks, channel matching)
- Reference files for email templates, jargon simplification, meeting structures, and remote async communication

## When to Use

- Drafting emails (status updates, requests, escalations, introductions)
- Writing Slack/Teams messages
- Preparing meeting agendas or summaries
- Translating technical concepts for non-technical audiences
- Any written communication to teammates, managers, or stakeholders

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/writing/professional-communication
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install professional-communication
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/writing/professional-communication .cursor/skills/professional-communication
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/writing/professional-communication ~/.cursor/skills/professional-communication
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/writing/professional-communication .claude/skills/professional-communication
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/writing/professional-communication ~/.claude/skills/professional-communication
```

## Related Skills

- **clear-writing** — Foundational writing principles that apply to all professional communication

---

Part of the [Writing](..) skill category.
