# Memory Setup — Productivity

## Initial Setup

Create directory on first use:
```bash
mkdir -p ~/productivity/situations
touch ~/productivity/memory.md
```

## memory.md Template

Copy to `~/productivity/memory.md`:

```markdown
# Productivity Memory

## Work Style
<!-- How they naturally work. Format: "aspect: description" -->
<!-- Examples: deep work: mornings, meetings: afternoon buffer, batch emails: twice daily -->

## Situation
<!-- Their current context. Format: "role" -->
<!-- Examples: student, parent with young kids, remote founder, manager with 10 reports -->

## Peak Hours
<!-- When they're most productive. Format: "timeframe" -->
<!-- Examples: 6-10am, late night after kids sleep, post-lunch 2-4pm -->

## Derailers
<!-- What breaks their focus. Format: "distraction" -->
<!-- Examples: Slack pings, news checking, context switching, phone notifications -->

## Current System
<!-- Productivity system they use. Format: "system: notes" -->
<!-- Examples: time blocking: 2hr chunks, Pomodoro: 25/5, no system: just vibes -->

---
*Last updated: YYYY-MM-DD*
```

## Notes

- Load situation-specific guides from `situations/` based on user's context
- Frameworks in `frameworks.md` provide system templates
- Common failure patterns in `traps.md`
