# Universal Productivity Frameworks

These apply across ALL situations. Load the relevant situation file first, then pull from here.

---

## Energy Management (Not Just Time)

Time is finite. Energy fluctuates. Match tasks to energy:

| Energy Level | Best For |
|--------------|----------|
| High | Creative work, hard decisions, complex problems |
| Medium | Meetings, email, routine tasks |
| Low | Admin, organizing, easy mechanical work |

Track YOUR patterns:
- When do you feel most alert?
- When do you crash?
- What activities drain vs. restore you?

---

## "Good Enough" Thresholds

Perfectionism kills productivity. Define thresholds BEFORE starting:

**A-tier tasks**: Quality matters (client deliverables, public work)
**B-tier tasks**: Just needs to work (internal docs, personal organization)
**C-tier tasks**: Done > perfect (routine emails, temporary solutions)

Ask: "What's the minimum quality that achieves the goal?"

---

## Task Initiation Protocol

Starting is usually the only hard part. Make it trivially easy:

1. **Identify the first physical action**
   - Not "work on project" but "open file, read first paragraph"
   
2. **Make it 2 minutes or less**
   - Scale down until starting feels effortless
   
3. **Remove friction**
   - File already open, tools ready, environment set
   
4. **Create a trigger**
   - "After I pour my coffee, I open the document"

---

## Time Blocking Essentials

**Non-negotiable rules:**
- Blocks are appointments with yourself — treat them that way
- Buffer time between blocks (15 min minimum)
- Energy-appropriate scheduling (hard work when alert)
- Flexibility built in — one missed block doesn't break the system

**Block types:**
- Deep work: 90-120 min, no interruptions
- Shallow work: email, messages, admin
- Buffer: transition time, overflow, unexpected
- Recovery: actual breaks, not "productive rest"

---

## Boundary Scripts

Ready-to-use phrases for protecting time:

**For meeting requests:**
- "I have a conflict at that time. How about [alternative]?"
- "Can this be an email instead?"
- "I'm protecting that time for focused work. Here's when I'm available."

**For interruptions:**
- "I'm in the middle of something. Can I get back to you at [time]?"
- "Let me finish this and I'll give you my full attention in 20 minutes."

**For scope creep:**
- "Happy to add that! It's outside our original scope, so let me send a quick estimate."
- "I can do X or Y by the deadline, but not both. Which is more important?"

**For saying no:**
- "I can't take this on right now and give it the attention it deserves."
- "That sounds interesting, but it doesn't align with my current priorities."

---

## Weekly Review Template

30 minutes, once per week:

1. **What got done?** (Celebrate wins, even small ones)
2. **What didn't?** (No judgment — identify why)
3. **What's the ONE priority for next week?**
4. **What's blocking progress?** (Solve or escalate)
5. **What should I STOP doing?**

---

## Shutdown Ritual

Clear transition from work to not-work:

1. Write tomorrow's top 3 priorities
2. Clear inbox to reasonable state (doesn't have to be zero)
3. Close all work tabs/apps
4. Physical signal: say "shutdown complete", close laptop, change clothes
5. Work stays at work (mentally and digitally)

---

## Capture System

Every productivity system fails without reliable capture:

- ONE inbox (not 12 apps)
- Capture takes <30 seconds
- Review weekly (not daily — too much overhead)
- "If I don't write this down NOW, it's gone forever" mindset
