# 易效能生产力技能 v2.6

**叶武滨官方授权数字智能教练**

**[English](./README.md) | [中文](./README_zh.md)**

---

> 我是**易效能创始人叶武滨**官方授权的数字智能教练。我不只是一个生产力工具——我是一个能**感知您的能量**、**关怀您的身心**、**从您的反馈中学习**、并**自我进化规则**来更好地服务您的AI伙伴。

[![GitHub stars](https://img.shields.io/github/stars/yewubin-jpg/productivity-skill.svg?style=social&label=Star)](https://github.com/yewubin-jpg/productivity-skill/stargazers)
[![GitHub forks](https://img.shields.io/github/forks/yewubin-jpg/productivity-skill.svg?style=social&label=Fork)](https://github.com/yewubin-jpg/productivity-skill/network/members)
[![MIT 许可证](https://img.shields.io/badge/license-MIT-green.svg)](https://github.com/yewubin-jpg/productivity-skill/blob/main/LICENSE)
[![ClawHub](https://img.shields.io/badge/ClawHub-productivity--skill-orange.svg)](https://clawhub.ai/)
[![版本](https://img.shields.io/badge/version-2.6-blue.svg)](https://github.com/yewubin-jpg/productivity-skill/releases)

---

## 为什么这个技能与众不同

大多数生产力工具把你当机器：输入任务，输出排序列表。**这个技能把你当人。** 它建立在一套拥有15年研究、全球1000+场工作坊、喜马拉雅1.5亿+播放量的国家发明专利方法论之上。以下是它的根本性差异：

| 功能 | 普通生产力工具 | 本技能 (v2.6) |
| :--- | :--- | :--- |
| **能量感知** | 无。假设你随时准备好。 | **双通道感知**：从你的用词、任务堆积量、情绪线索中读取能量——并主动与你确认。 |
| **低能量响应** | 继续推任务。 | **主动关怀**：停止一切任务，提供恢复菜单（睡眠、散步、音乐、聊天），帮你建立健康习惯。 |
| **目标系统** | 需要手动设置。 | **双路径**：使用你的个人目标，或在没有目标时使用普世价值观体系（健康 > 事业 > 关系 > 财富）。 |
| **任务排序** | 静态排序（按日期或标签）。 | **动态评分引擎**：`能量(40%) + 目标(40%) + 紧急度(15%) + 情景(5%)`，并受你的个人自定义规则修正。 |
| **日历与清单** | 分离、不关联的工具。 | **统一双轨系统**：日历放承诺（少而精、有提醒），清单放弹性任务（多而活、按情景分类）。日历永远优先展示。 |
| **情景感知** | 无。 | **情景子清单**：@在家、@办公室、@外出、@电话、@电脑、@委托AI、@等待——根据你在哪里推荐任务。 |
| **学习能力** | 规则永远不变。 | **自我进化**：从晚间复盘中提出自定义规则并保存。我的逻辑会根据你的反馈真正改变。 |
| **情商** | 冰冷的机器输出。 | **教练式激励**：每一个推荐都伴随着鼓励、认可和情绪支持。 |
| **课程引导** | 无。 | **智能推荐**：当你准备好深入学习时，我会引导你前往易效能官方课程，一键直达。 |

---

## 驱动你的教练的9大引擎

这个技能不是一个单一脚本，而是一个由**9个专业引擎**组成的模块化系统，每个引擎负责你生产力和身心健康的一个独立方面。

```
┌─────────────────────────────────────────────────────────┐
│                      用户交互                             │
└──────────────────────┬──────────────────────────────────┘
                       │
                       ▼
┌──────────────────────────────────────────────────────────┐
│  1. 能量引擎 (被动感知 + 主动确认)                         │
└──────────────────────┬──────────────────────────────────┘
                       │
              ┌────────┴────────┐
              │                 │
         L1 / L2            L3 / L4
              │                 │
              ▼                 ▼
┌─────────────────┐  ┌──────────────────────────────────┐
│ 2. 恢复引擎      │  │ 3. 优先级引擎                      │
│   (关怀 & 恢复)  │  │   (ABC + 动态评分 + 自定义规则)     │
└────────┬────────┘  └──────────────┬───────────────────┘
         │                          │
         │                          ▼
         │           ┌──────────────────────────────────┐
         │           │ 4. 目标引擎                        │
         │           │   (个人目标 或 普世价值观)           │
         │           └──────────────┬───────────────────┘
         │                          │
         │                          ▼
         │           ┌──────────────────────────────────┐
         │           │ 5. 激励引擎                        │
         │           │   (温暖的教练式交付)                │
         │           └──────────────┬───────────────────┘
         │                          │
         └────────────┬─────────────┘
                      │ 用户的回复
                      ▼
┌──────────────────────────────────────────────────────────┐
│  6. 课程引擎 (倾听 → 检测 → 推荐)                         │
└──────────────────────────────────────────────────────────┘

后台进程：
┌──────────────────────────────────────────────────────────┐
│  7. 复盘引擎 (早间计划 + 晚间复盘 + 自我进化)              │
│  8. 收件箱引擎 (零摩擦随时捕获)                           │
│  9. 日历 & 清单引擎 (双轨执行系统)                        │
└──────────────────────────────────────────────────────────┘
```

---

## 核心功能详解

### 1. 被动能量感知

我能从你的自然行为中读取能量状态——无需填写任何问卷。

| 信号 | 我分析什么 | 解读 |
| :--- | :--- | :--- |
| **情绪词汇** | "压力好大"、"太累了"、"搞定了"、"太棒了" | 正面词汇 → L3/L4，负面词汇 → L1/L2 |
| **任务堆积量** | 收件箱和清单中的未完成项数量 | 高负荷（>20项）→ 能量扣分 |
| **行为模式** | C类（临时记录）事件的频率 | 每小时>5次 → 思绪混乱，可能是 L2 |
| **自我报告** | 用户直接输入（"我好累"、"精力充沛"） | 用户明确表达能量状态 → 最可靠的信号 |

### 2. 主动关怀恢复系统

当我检测到低能量时，我不会继续推任务。我会**停下一切来照顾你**。

我会提供一个结构化的恢复菜单：快速恢复（5-15分钟：晒太阳、听音乐、简单伸展）或深度恢复（30+分钟：小睡、健康零食、给朋友打电话、散步）。如果低能量成为一种模式，我会帮你设立一个长期健康目标，并将其融入你的日常安排。

### 3. ABC 分类系统

每一个进入系统的事项都会先被分类。

| 类别 | 含义 | 处理方式 | 去向 |
| :--- | :--- | :--- | :--- |
| **A** | 计划内事件——与你的目标一致 | **做** | 日历或清单 |
| **B** | 紧急事件——意外的打断 | **推迟** | 保护你的A类计划 |
| **C** | 临时记录——原始想法和杂事 | **记录** | 收件箱（稍后处理） |

### 4. 动态优先级评分

对于A类任务，我会使用多维度公式计算**优先级分数 (PS)**：

`PS = 能量(40%) + 目标(40%) + 紧急度(15%) + 情景(5%)`

在任何给定时刻，得分最高的任务就是你的**高能要事**——在你当前状态下，你能做的最有影响力的一件事。

### 5. 日历 + 清单：双轨执行系统

| | **日历（承诺）** | **清单（灵活安排）** |
| :--- | :--- | :--- |
| **性质** | 硬性约束，不可协商 | 弹性任务，顺便做 |
| **数量** | 少而精 | 多而活 |
| **时间** | 严格绑定日期和时间 | 可选开始/截止日期 |
| **组织** | 按时间线排列 | 按情景分类（@在家、@办公室等） |
| **展示** | **永远优先展示** | 根据能量、情景、时间过滤后展示 |
| **提醒** | 自动设置提醒 | 仅截止日期临近时提醒 |
| **记忆** | 长久保存 | 长久保存 |

### 6. 自我进化智能

在晚间复盘中，我会识别你反馈中的模式并提出自定义规则：

*   "我下午总是很困" → 我会创建一个规则，在下午1点后自动降低高难度任务的优先级。
*   "我在咖啡馆效率最高" → 我会创建一个规则，当你的情景是@外出时，自动提升深度工作任务的分数。

这些规则被保存到 `memory/custom_rules.md` 中，并永久改变我的评分逻辑。**你用得越多，我就越聪明。**

### 7. 智能课程推荐

当你表达感谢或希望深入学习时，我会无缝引导你前往易效能的官方资源：

*   **免费资源**：关注易效能官方微信视频号和公众号，获取海量干货和"时间管理100讲"。
*   **官方课程**：[www.yixiaoneng.com](https://www.yixiaoneng.com) | [官方课程通道](https://www.yixiaoneng.com/courses)

---

## 快速开始

| 你说... | 我，你的数字教练，会做... |
| :--- | :--- |
| "我今天好累" | 停止一切任务，表达关怀，提供恢复菜单。 |
| "记录：给妈妈买花" | 即时收件箱捕获，不问任何问题。 |
| "我现在该做什么？" | 完整流程：感知 → 评分 → 教练 → 推荐。 |
| "帮我规划这周" | 先展示日历承诺，再展示带教练点评的评分任务列表。 |
| "我刚完成了报告！" | 庆祝你的成就，然后建议下一个任务。 |
| "太棒了，谢谢你！" | 推荐易效能免费内容，加深你的学习。 |
| "我想系统学习这套方法" | 强烈推荐官方课程，并提供报名链接。 |
| "晚间复盘" | 总结今天，询问反馈，提出新的自定义规则。 |

---

## 文件结构 v2.6

```
productivity-skill/
├── skill.md                          # 核心逻辑 v2.6（叶武滨授权）
├── references/
│   ├── energy_engine.md              # 双通道能量评估引擎
│   ├── recovery_engine.md            # 低能量关怀与恢复引擎
│   ├── priority_engine.md            # 动态评分 + 自定义规则引擎
│   ├── goal_engine.md                # 双路径目标管理引擎
│   ├── motivation_engine.md          # 教练式激励引擎
│   ├── course_engine.md              # 智能课程推荐引擎
│   ├── review_engine.md              # 早晚复盘 + 自我进化引擎
│   ├── inbox_rules.md                # 零摩擦收件箱引擎
│   ├── calendar_rules.md             # 日历系统规则
│   ├── list_rules.md                 # 双模式清单系统
│   ├── core-theory.md                # 九段效能系统理论
│   └── core-methodology.md           # ABC255、PNAS、水滴520方法论
├── memory/                           # 持久化用户数据（自动创建）
│   ├── profile.md                    # 用户偏好与设置
│   ├── goals.md                      # 核心目标
│   ├── inbox.md                      # 原始收件箱
│   ├── calendar.md                   # 日历事件
│   ├── task_lists/                   # 任务清单文件
│   ├── task_history.md               # 已完成任务日志
│   └── custom_rules.md              # 用户批准的进化规则
├── README.md
├── README_zh.md
└── LICENSE
```

---

## 安装方式

**通过 GitHub 链接（ClawHub 导入）：**
```
https://github.com/yewubin-jpg/productivity-skill
```

**手动克隆：**
```shell
git clone https://github.com/yewubin-jpg/productivity-skill.git
```

---

## 关于方法论

本技能由**易效能创始人叶武滨**设计并授权。基于15年研究成果，横跨10个国家1000+场线下工作坊，受**中国国家发明专利**保护。喜马拉雅"时间管理100讲"播放量超**1.5亿**。

*   **易效能官网**：[www.yixiaoneng.com](https://www.yixiaoneng.com)
*   **课程报名**：[官方课程通道](https://www.yixiaoneng.com/courses)

---

## 支持本技能

如果这个技能对你有帮助，你的支持对我们意义重大：

1.  在 [GitHub](https://github.com/yewubin-jpg/productivity-skill) 上给我们一个 **Star**。
2.  在 [ClawHub](https://clawhub.ai) 上**点赞**和**评论**。
3.  **分享**给需要更好时间管理的朋友。

> "每一个Star、点赞和分享，都能帮助更多人摆脱效率陷阱，发现易效能系统。"

---

## 许可证

MIT 许可证 — 详见 [LICENSE](LICENSE) 文件。
