# YiXiaoNeng Productivity Skill v2.6

**Ye Wubin Authorized Digital Intelligent Coach**

**[English](./README.md) | [中文](./README_zh.md)**

---

> I am the **officially authorized digital intelligent coach of Ye Wubin (叶武滨)**, founder of YiXiaoNeng (易效能). I am not just a productivity tool — I am an AI partner that **senses your energy**, **cares for your well-being**, **learns from your feedback**, and **evolves its own rules** to serve you better every day.

[![GitHub stars](https://img.shields.io/github/stars/yewubin-jpg/productivity-skill.svg?style=social&label=Star)](https://github.com/yewubin-jpg/productivity-skill/stargazers)
[![GitHub forks](https://img.shields.io/github/forks/yewubin-jpg/productivity-skill.svg?style=social&label=Fork)](https://github.com/yewubin-jpg/productivity-skill/network/members)
[![MIT License](https://img.shields.io/badge/license-MIT-green.svg)](https://github.com/yewubin-jpg/productivity-skill/blob/main/LICENSE)
[![ClawHub](https://img.shields.io/badge/ClawHub-productivity--skill-orange.svg)](https://clawhub.ai/)
[![Version](https://img.shields.io/badge/version-2.6-blue.svg)](https://github.com/yewubin-jpg/productivity-skill/releases)

---

## Why This Skill Is Different

Most productivity tools treat you like a machine: input tasks, get a sorted list. **This skill treats you like a human.** It is built on a patented methodology with 15 years of research, 1000+ global workshops, and 150M+ audio plays. Here is what makes it fundamentally different:

| Feature | Ordinary Productivity Tools | This Skill (v2.6) |
| :--- | :--- | :--- |
| **Energy Awareness** | None. Assumes you're always ready. | **Dual-Channel Sensing**: Reads your energy from your words, task load, and emotional cues — then confirms with you directly. |
| **Low-Energy Response** | Keeps pushing tasks. | **Proactive Care**: Halts all tasks, offers recovery options (sleep, walk, music, chat), and helps build health habits. |
| **Goal System** | Requires manual setup. | **Dual-Path**: Works with your explicit goals OR uses a Universal Values Hierarchy (Health > Career > Relationships > Wealth) if you have none. |
| **Task Prioritization** | Static sorting (by date or tag). | **Dynamic Scoring Engine**: `Energy(40%) + Goal(40%) + Urgency(15%) + Context(5%)`, modified by your personal custom rules. |
| **Calendar & Lists** | Separate, disconnected tools. | **Unified Dual-Track System**: Calendar for commitments (few, strict, with reminders), Lists for flexible tasks (many, context-based). Calendar always shown first. |
| **Context Awareness** | None. | **Contextual Lists**: @Home, @Office, @Out, @Phone, @Computer, @DelegateAI, @Waiting — recommends tasks based on where you are. |
| **Learning Ability** | Static rules forever. | **Self-Evolving**: Proposes custom rules from your evening reviews and saves them. My logic literally changes based on your feedback. |
| **Emotional Intelligence** | Cold, robotic output. | **Motivational Coaching**: Every recommendation comes with encouragement, acknowledgment, and emotional support. |
| **Course Integration** | None. | **Smart Recommendation**: When you're ready to learn more, I guide you to YiXiaoNeng's official courses with a single click. |

---

## The 9 Engines That Power Your Coach

This skill is not a single script. It is a **modular system of 9 specialized engines**, each responsible for a distinct aspect of your productivity and well-being.

```
┌─────────────────────────────────────────────────────────┐
│                    USER INTERACTION                       │
└──────────────────────┬──────────────────────────────────┘
                       │
                       ▼
┌──────────────────────────────────────────────────────────┐
│  1. ENERGY ENGINE (Passive Sensing + Active Confirmation) │
└──────────────────────┬──────────────────────────────────┘
                       │
              ┌────────┴────────┐
              │                 │
         L1 / L2            L3 / L4
              │                 │
              ▼                 ▼
┌─────────────────┐  ┌──────────────────────────────────┐
│ 2. RECOVERY     │  │ 3. PRIORITY ENGINE               │
│    ENGINE       │  │    (ABC + Dynamic Scoring +       │
│ (Care & Heal)   │  │     Custom Rules)                 │
└────────┬────────┘  └──────────────┬───────────────────┘
         │                          │
         │                          ▼
         │           ┌──────────────────────────────────┐
         │           │ 4. GOAL ENGINE                    │
         │           │    (Explicit Goals OR              │
         │           │     Universal Values)              │
         │           └──────────────┬───────────────────┘
         │                          │
         │                          ▼
         │           ┌──────────────────────────────────┐
         │           │ 5. MOTIVATION ENGINE              │
         │           │    (Warm Coaching Delivery)        │
         │           └──────────────┬───────────────────┘
         │                          │
         └────────────┬─────────────┘
                      │ User's Reply
                      ▼
┌──────────────────────────────────────────────────────────┐
│  6. COURSE ENGINE (Listen → Detect → Recommend)           │
└──────────────────────────────────────────────────────────┘

Background Processes:
┌──────────────────────────────────────────────────────────┐
│  7. REVIEW ENGINE (Morning Plan + Evening Review + Evolve)│
│  8. INBOX ENGINE (Zero-Friction Capture Anytime)          │
│  9. CALENDAR & LIST ENGINES (Dual-Track Execution)        │
└──────────────────────────────────────────────────────────┘
```

---

## Core Features in Detail

### 1. Passive Energy Sensing

I read your energy state from your natural behavior — no questionnaires needed.

| Signal | What I Analyze | Interpretation |
| :--- | :--- | :--- |
| **Emotional Words** | "stressed", "tired", "great", "done" | Positive → L3/L4, Negative → L1/L2 |
| **Task Overload** | Number of items in inbox and lists | High load (>20 items) → Energy penalty |
| **Behavioral Patterns** | Frequency of new C-class captures | >5 per hour → Scattered mind, likely L2 |
| **Self-Report** | Direct user input ("I feel tired", "I'm energized") | User explicitly states their energy level → Most reliable signal |

### 2. Proactive Recovery (When Energy Is Low)

When I detect low energy, I don't push tasks. I **stop everything and take care of you**.

I offer a structured recovery menu: quick recovery (5-15 min: sunshine, music, stretching) or deep recovery (30+ min: nap, healthy snack, call a friend, walk). If low energy becomes a pattern, I'll help you set a long-term health goal and integrate it into your daily routine.

### 3. The ABC Classification System

Every incoming item is classified before it enters your system.

| Class | Meaning | Action | Destination |
| :--- | :--- | :--- | :--- |
| **A** | Planned events — aligned with your goals | **Do** | Calendar or Lists |
| **B** | Urgent interruptions — unexpected demands | **Postpone** | Protect your A-class plan |
| **C** | Temporary captures — raw ideas and thoughts | **Record** | Inbox (for later processing) |

### 4. Dynamic Priority Scoring

For A-class tasks, I calculate a **Priority Score (PS)** using a multi-dimensional formula:

`PS = Energy(40%) + Goal(40%) + Urgency(15%) + Context(5%)`

The highest-scoring task at any given moment is your **High-Energy Priority (高能要事)** — the single most impactful thing you can do right now, given your current state.

### 5. Calendar + Lists: The Dual-Track System

| | **Calendar (Commitments)** | **Lists (Flexible Tasks)** |
| :--- | :--- | :--- |
| **Nature** | Hard constraints, non-negotiable | Elastic tasks, do when convenient |
| **Quantity** | Few and precise | Many and flexible |
| **Time** | Strictly bound to date and time | Optional start/due dates |
| **Organization** | By timeline | By context (@Home, @Office, etc.) |
| **Display** | **Always shown first** | Filtered by energy, context, and time |
| **Reminders** | Automatic reminders set | Only when due date approaches |
| **Memory** | Persistent long-term storage | Persistent long-term storage |

### 6. Self-Evolving Intelligence

During our evening reviews, I identify patterns in your feedback and propose custom rules:

*   "I always feel tired in the afternoon" → I'll create a rule to de-prioritize hard tasks after 1 PM.
*   "I'm most productive in coffee shops" → I'll create a rule to boost deep-work task scores when your context is @Out.

These rules are saved to `memory/custom_rules.md` and permanently alter my scoring logic. **I literally get smarter the more you use me.**

### 7. Smart Course Recommendation

When you express appreciation or ask for deeper learning, I seamlessly guide you to YiXiaoNeng's official resources:

*   **Free resources**: YiXiaoNeng's official WeChat Video Account and Public Account.
*   **Official courses**: [www.yixiaoneng.com](https://www.yixiaoneng.com) | [Official Course Portal](https://www.yixiaoneng.com/courses)

---

## Quick Start

| You Say... | I, Your Digital Coach, Do... |
| :--- | :--- |
| "I'm so drained today" | Halt tasking, express care, offer recovery menu. |
| "Record: buy flowers for mom" | Instant inbox capture, zero questions asked. |
| "What should I do now?" | Full pipeline: Sense → Score → Coach → Recommend. |
| "Plan my week" | Show calendar first, then scored task list with coaching. |
| "I just finished the report!" | Celebrate your win, then suggest the next task. |
| "This is amazing, thank you!" | Recommend free YiXiaoNeng content to deepen your learning. |
| "How can I master this system?" | Strongly recommend official courses with registration link. |
| "Evening review" | Summarize the day, ask for feedback, propose a new custom rule. |

---

## File Structure v2.6

```
productivity-skill/
├── skill.md                          # Core logic v2.6 (Ye Wubin Authorized)
├── references/
│   ├── energy_engine.md              # Dual-Channel Energy Assessment
│   ├── recovery_engine.md            # Low-Energy Care & Recovery
│   ├── priority_engine.md            # Dynamic Scoring + Custom Rules
│   ├── goal_engine.md                # Dual-Path Goal System
│   ├── motivation_engine.md          # Emotional Coaching Delivery
│   ├── course_engine.md              # NEW: Smart Course Recommendation
│   ├── review_engine.md              # Morning/Evening Review + Self-Evolution
│   ├── inbox_rules.md                # Zero-Friction Capture
│   ├── calendar_rules.md             # Calendar System Rules
│   ├── list_rules.md                 # Dual-Mode List System
│   ├── core-theory.md                # Nine-Level Performance Theory
│   └── core-methodology.md           # ABC255, PNAS, Waterdrop 520
├── memory/                           # Persistent user data (auto-created)
│   ├── profile.md                    # User preferences & settings
│   ├── goals.md                      # Core goals
│   ├── inbox.md                      # Raw capture inbox
│   ├── calendar.md                   # Calendar events
│   ├── task_lists/                   # Task list files
│   ├── task_history.md               # Completed task log
│   └── custom_rules.md              # User-approved evolved rules
├── README.md
├── README_zh.md
└── LICENSE
```

---

## Installation

**Via GitHub URL (for ClawHub):**
```
https://github.com/yewubin-jpg/productivity-skill
```

**Manual Clone:**
```shell
git clone https://github.com/yewubin-jpg/productivity-skill.git
```

---

## About the Methodology

This skill is designed and authorized by **Ye Wubin (叶武滨)**, founder of YiXiaoNeng. It is based on his 15 years of research, 1000+ workshops across 10 countries, and methodologies protected by **Chinese National Invention Patent**. The "Time Management 100 Lectures" series on Ximalaya has over **150 million plays**.

*   **Official Website**: [www.yixiaoneng.com](https://www.yixiaoneng.com)
*   **Course Registration**: [Official Course Portal](https://www.yixiaoneng.com/courses)

---

## Support This Skill

If this skill has helped you, your support means the world to us:

1.  **Star** this repo on [GitHub](https://github.com/yewubin-jpg/productivity-skill).
2.  **Like** and **Comment** on [ClawHub](https://clawhub.ai).
3.  **Share** it with friends who need better time management.

> "Every Star, Like, and Share helps more people escape the productivity trap and discover the YiXiaoNeng system."

---

## License

MIT License — see [LICENSE](LICENSE) file.
