# Product Validation

## Customer Discovery

### Problem Interview Script
```
1. "Tell me about the last time you [experienced the problem]"
2. "What did you do about it?"
3. "What don't you love about that solution?"
4. "If you could wave a magic wand, what would be different?"
5. "How much time/money does this problem cost you?"
```

### The Mom Test (Key Principles)
- Never pitch; only listen
- Ask about the past, not hypothetical futures
- "Would you use X?" is worthless — ask what they did last time
- Compliments are noise; commitments are signal
- Get specifics: "When was the last time...?"

## Validation Experiments

### Smoke Test (Landing Page)
- Create landing page describing solution
- Drive traffic (ads, communities)
- Measure signup/waitlist conversion
- **Benchmark:** 10%+ email capture = signal

### Fake Door Test
- Add button/feature that doesn't exist yet
- Track clicks as demand signal
- Show "coming soon" on click
- **Use for:** validating specific features within existing product

### Concierge MVP
- Deliver the value manually before building
- You are the product
- Learn exact workflow before automating
- **Best for:** complex workflows, high-value services

### Wizard of Oz
- User thinks it's automated; you do it manually behind scenes
- Test UX without building backend
- **Best for:** AI features, complex logic

### Pre-Order Campaign
- Take money before building
- Refundable deposits = real commitment
- **Benchmark:** if people won't pay, don't build

## Quantitative Validation

### Sean Ellis PMF Survey
**Question:** "How would you feel if you could no longer use [product]?"
- Very disappointed → Core users
- Somewhat disappointed → Interested, not hooked
- Not disappointed → Wrong segment

**Target:** 40%+ "Very disappointed" = PMF signal

**Follow-ups:**
1. "What type of people would most benefit?"
2. "What is the primary benefit you receive?"
3. "How can we improve for you?"

**Sample size:** 40-50 active users minimum

### Retention Curve Analysis
- Plot retention by cohort over time
- **Flattening curve** = PMF (users stick)
- **Declining to zero** = no PMF
- **Smile curve (uptick)** = strong PMF (users return)

## Market Validation

### TAM/SAM/SOM
- **TAM:** Total Addressable Market (everyone who could use it)
- **SAM:** Serviceable Addressable Market (your target segment)
- **SOM:** Serviceable Obtainable Market (realistic capture in 1-3 years)

### Competition Mapping
| Quadrant | Your Position |
|----------|---------------|
| No competition | Either no market, or you found whitespace |
| Direct competition | Need differentiation strategy |
| Indirect competition | Different approach to same job |
| Non-consumption | Biggest opportunity; people doing nothing today |

## Frameworks

### Jobs-to-be-Done (JTBD)
**Format:** "When [situation], I want to [motivation], so I can [outcome]"

**Example:** "When I'm managing a distributed team, I want to see what everyone is working on without interrupting them, so I can make better resource decisions."

**Three dimensions:**
1. Functional — the practical task
2. Emotional — how they want to feel
3. Social — how they want to be perceived

### Value Proposition Canvas
**Customer side:**
- Jobs they're trying to do
- Pains they experience
- Gains they desire

**Product side:**
- Products & services offered
- Pain relievers (how you address pains)
- Gain creators (how you deliver gains)

**Fit = Pain relievers address pains + Gain creators deliver gains**
