# Image Specifications by Platform

## Amazon

### Product Images
| Element | Requirement |
|---------|-------------|
| Main image background | Pure white (RGB 255,255,255) |
| Minimum size | 1000px on longest side |
| Optimal (zoom) | 1600px+ on longest side |
| Maximum size | 10,000px |
| Formats | JPEG (preferred), PNG, TIFF, GIF |
| File size | Max 10MB |
| Product fill | At least 85% of frame |
| Main image rules | No text, watermarks, logos, borders |
| Image count | Up to 9 (1 main + 8 additional) |

### A+ Content Images
| Type | Dimensions |
|------|------------|
| Logo | 600 × 180 px |
| Header with text | 970 × 600 px |
| Standard image | 970 × 300 px |
| Comparison chart | 150 × 300 px |
| Max file size | 2MB per image |

## Etsy

| Element | Requirement |
|---------|-------------|
| Minimum | 2000 × 2000 px |
| Recommended aspect | 4:3 or 1:1 |
| Image count | Up to 10 |
| Video | 5-15 seconds, 100MB max |
| First image | Thumbnail in search |
| SEO note | First 160 chars of title show in search |

## Shopify

| Element | Requirement |
|---------|-------------|
| Recommended | 2048 × 2048 px (square) |
| Variants | Individual images supported |
| No strict requirements | Very flexible |
| CDN | Automatic optimization |

## Print-on-Demand

### Printful
| Product | Dimensions | DPI |
|---------|------------|-----|
| T-Shirt (DTG) | 4500 × 5400 px | 150+ |
| All-Over Print | 6900 × 10200 px | 150 |
| Hoodie (front) | 4500 × 4800 px | 150+ |
| Mug (11oz) | 4500 × 1100 px | 300 |
| Poster | Varies by size | 300 |
| Phone Case | 1800 × 1800 px | 300 |

- Format: PNG with transparency
- Max file: 200 MB
- Color: RGB (sRGB)

### Printify
| Product | Dimensions | DPI |
|---------|------------|-----|
| T-Shirt | 4500 × 5400 px | 300 |
| Mug | 2130 × 900 px | 300 |
| Poster | Size-based | 300 |

- Format: PNG (transparent), JPG
- Max file: 100 MB
- Note: Varies by print provider

### Amazon Merch
| Product | Dimensions | DPI |
|---------|------------|-----|
| Standard T-Shirt | 4500 × 5400 px | 300 |
| Premium T-Shirt | 4500 × 5400 px | 300 |
| Hoodie | 4500 × 4050 px | 300 |
| PopSockets | 1125 × 1125 px | 300 |
| Phone Cases | 2100 × 3300 px | 300 |
| Tote Bags | 4500 × 4500 px | 300 |

- **MUST be PNG** with transparent background
- Max file: 25 MB
- Strict trademark enforcement

### Redbubble
| Product | Minimum | Optimal |
|---------|---------|---------|
| Default upload | 2400 × 3200 px | 7632 × 6480 px |
| Stickers | 1000 × 1000 px | 2800 × 2800 px |
| T-Shirts | 2400 × 3200 px | 4600 × 5200 px |

- Format: PNG, JPG, GIF
- Uploads ONE master, auto-scales to all products
- RGB color mode

### Gelato
| Product | Dimensions | DPI |
|---------|------------|-----|
| T-Shirt | 3000 × 3000 px min | 150-300 |
| Posters | Size-based + 3mm bleed | 300 |
| Canvas | Size-based + wrap | 150 |

- Format: PNG, JPG, PDF
- Global production (35+ countries)

## Social Media

### Instagram
| Format | Dimensions |
|--------|------------|
| Feed (square) | 1080 × 1080 px |
| Feed (portrait) | 1080 × 1350 px (4:5) |
| Stories/Reels | 1080 × 1920 px (9:16) |
| Carousel | 1080 × 1080 px each |

### Pinterest
| Format | Dimensions |
|--------|------------|
| Standard pin | 1000 × 1500 px (2:3) |
| Idea pin | 1080 × 1920 px |

### Facebook
| Format | Dimensions |
|--------|------------|
| Feed | 1200 × 630 px |
| Product catalog | 1024 × 1024 px |

## Quick Export Cheat Sheet

| Platform | Go-to Size | Format |
|----------|------------|--------|
| Amazon main | 2000 × 2000 | JPEG |
| Etsy | 2000 × 2000 | JPEG |
| Shopify | 2048 × 2048 | JPEG |
| POD T-shirt | 4500 × 5400 | PNG (transparent) |
| Instagram | 1080 × 1080 | JPEG |
| Pinterest | 1000 × 1500 | JPEG |
