# Product Imagery Prompts

## Studio Shots

### White Background (Catalog)
```
Professional product photography of [PRODUCT], centered on pure white background, 
soft diffused lighting from above and sides, subtle drop shadow, 
commercial catalog style, 8K, photorealistic
```

### Gradient Background
```
[PRODUCT] on smooth gradient background from [COLOR1] to [COLOR2], 
professional studio lighting, centered composition, commercial photography
```

### Dramatic Lighting
```
[PRODUCT] with dramatic Rembrandt lighting, dark background, 
single key light creating defined shadows, luxury brand aesthetic, 
high contrast, advertisement quality
```

## Lifestyle Shots

### In-Context Usage
```
[PRODUCT] in use in a [SETTING: modern kitchen/minimalist desk/cozy living room], 
natural window lighting, shallow depth of field, lifestyle photography,
warm tones, aspirational mood, editorial quality
```

### Hands Holding Product
```
[PRODUCT] held by [HAND DESCRIPTION: feminine hands with natural nails/masculine hands], 
clean background, natural lighting, showing scale and usage,
product photography, realistic proportions
```

### Environmental Placement
```
[PRODUCT] on [SURFACE: marble countertop/wooden table/grass], 
surrounded by [PROPS: coffee cup/plants/books], morning light,
lifestyle photography, Instagram aesthetic
```

## Mockups

### T-Shirt
```
[COLOR] t-shirt with [DESIGN DESCRIPTION] printed on chest,
worn by [MODEL TYPE: young man/woman] in casual pose,
natural lighting, lifestyle photo, realistic fabric texture
```

### Mug
```
[COLOR] ceramic mug with [DESIGN] printed on side,
on wooden table with steam rising, morning light through window,
cozy atmosphere, product photography
```

### Poster/Wall Art
```
[DESIGN] as framed poster on [WALL TYPE: white wall/exposed brick],
modern interior setting, natural light, interior design photography
```

### Phone Case
```
[DESIGN] phone case on iPhone, held in hand,
clean background, professional product shot, showing design clearly
```

### Packaging/Box
```
[PRODUCT] in [BOX STYLE: kraft/white/black] packaging,
on [SURFACE], professional product photography,
showing unboxing moment, clean composition
```

## Marketing Shots

### Hero Image (with text space)
```
[PRODUCT] positioned on [SIDE: left/right] of frame,
negative space on [OPPOSITE SIDE] for text overlay,
clean background, professional lighting, advertisement quality
```

### Before/After
```
Split composition showing [BEFORE STATE] on left, [AFTER STATE] on right,
clean transition line, same lighting both sides, comparison photo
```

### Flat Lay
```
Top-down view of [PRODUCTS] arranged in organized grid pattern,
on [BACKGROUND], soft shadows, catalog photography,
knolling style, symmetrical arrangement
```

## Color Variants

### Single Product, Multiple Colors
```
Same [PRODUCT] as reference image, identical composition and lighting,
but in [NEW COLOR] instead
```

### Color Lineup
```
[PRODUCT] shown in [COLOR1, COLOR2, COLOR3] lined up in row,
white background, consistent lighting, showing all color options
```

## Platform-Specific Tips

### Midjourney
- Add `--ar 1:1` for square, `--ar 4:5` for Instagram
- Use `--s 250` for more stylized, `--s 50` for realistic
- Add `--v 6` for latest version

### DALL-E 3
- Be specific about composition
- "wide shot" or "close-up" helps framing
- Good for text on products

### GPT-4o
- Describe iteratively, refine in conversation
- Can edit specific elements
- Best for complex compositions

## Quick Reference

### Quality Keywords
`professional, commercial, 8K, photorealistic, high-end, luxury, editorial`

### Lighting Keywords
`soft diffused, natural window light, studio lighting, Rembrandt, rim light`

### Background Keywords
`pure white, gradient, lifestyle setting, minimalist, clean, bokeh`

### Composition Keywords
`centered, rule of thirds, negative space, flat lay, 45-degree angle`
