# Product Pricing

## Pricing Models

| Model | Best For | Example |
|-------|----------|---------|
| Cost-plus | Physical goods | Cost + markup % |
| Value-based | Premium products | Based on perceived value |
| Competitive | Commodities | Match/undercut market |
| Penetration | New market entry | Low initial, raise later |
| Skimming | Innovation | High initial, lower over time |
| Freemium | SaaS | Free tier + paid upgrades |
| Usage-based | APIs, infrastructure | Pay per use |
| Tiered | SaaS, services | Good/Better/Best |

## Research Methods

### Van Westendorp Price Sensitivity
**Four questions:**
1. "At what price would it be **too expensive** to consider?"
2. "At what price would it be **expensive** but still consider?"
3. "At what price would it be a **bargain**?"
4. "At what price would it be **too cheap** to trust?"

**Analysis:** Plot cumulative distributions, find intersections:
- **Optimal Price:** Too cheap vs Too expensive crossing
- **Acceptable Range:** Between too cheap and too expensive

### Gabor-Granger
**Method:** Ask purchase likelihood at specific prices
**Output:** Demand curve, price elasticity

### A/B Testing Prices
- Test different price points
- Measure conversion rate
- Calculate revenue per visitor
- Need statistical significance

## Psychological Pricing

### Anchoring
- Show original price crossed out
- Display "compared to" reference
- Position premium option first

### Charm Pricing
- $19.99 vs $20.00 — left digit effect
- $29 vs $30 — feels much cheaper
- Use .99 for value products, round numbers for premium

### Decoy Effect
```
Small: $5
Large: $10
→ Most choose Large

Small: $5  
Medium: $8.50  ← Decoy
Large: $10
→ More choose Large (seems like better deal)
```

### Bundle Pricing
- Perceived savings drive purchases
- Anchor with individual prices
- "Save $X when you buy together"

## Platform Fee Calculations

### Amazon
| Fee | Typical Amount |
|-----|----------------|
| Referral | 8-15% |
| FBA Fulfillment | $3-5+ |
| Storage | Variable |
| **Total** | 30-45% |

### Etsy
| Fee | Amount |
|-----|--------|
| Listing | $0.20 |
| Transaction | 6.5% |
| Payment | 3% + $0.25 |
| Offsite Ads | 12-15% (if triggered) |
| **Total** | 20-30% |

### Shopify
| Fee | Amount |
|-----|--------|
| Platform | $29-299/mo |
| Transaction | 2.4-2.9% + $0.30 |
| **Total** | Variable |

### POD Margins
| Product | Base Cost | Typical Retail | Margin |
|---------|-----------|----------------|--------|
| T-shirt | $10-15 | $25-35 | $8-15 |
| Hoodie | $25-35 | $45-65 | $10-20 |
| Mug | $6-10 | $15-25 | $5-12 |
| Poster | $8-15 | $20-40 | $8-15 |

## SaaS Pricing Tiers

### Three-Tier Structure
| Tier | Purpose | Pricing Psychology |
|------|---------|-------------------|
| **Good** | Get users in | Anchor low, remove friction |
| **Better** | Target most users | "Obvious choice" |
| **Best** | Maximize capture | Anchor high, make Better seem reasonable |

### Differentiation Strategies
- Feature access
- Usage limits (storage, API calls, users)
- Support level
- Customization options

### Value Metrics
| Type | Examples | Best For |
|------|----------|----------|
| Per seat | Slack, Notion | Collaboration |
| Usage-based | AWS, Twilio | Infrastructure |
| Feature-tier | Most SaaS | Clear feature differentiation |
| Flat rate | Basecamp | Simplicity positioning |

## Pricing Strategy by Stage

### Launch
- Validate willingness to pay before scaling
- Pre-orders test real demand
- Start slightly high (easier to discount than raise)

### Growth
- Optimize for CAC payback
- Test price elasticity
- Consider annual discounts

### Mature
- Introduce premium tiers
- Usage-based expansion revenue
- Price increases for existing customers (carefully)

## When to Raise Prices

**Signals:**
- Conversion rate too high (leaving money on table)
- No price objections in sales calls
- Competitors charge more
- You've added significant value

**How:**
- Grandfather existing customers (or offer upgrade path)
- Add features to justify
- Communicate value, not just price change
