# Print-on-Demand Selling

## Platform Comparison

| Platform | Best For | Margins | Product Range |
|----------|----------|---------|---------------|
| Printful | Quality-focused | Medium | Wide |
| Printify | Price-focused | Better | Widest (50+ providers) |
| Gelato | International | Good | Good |
| Gooten | Variety | Medium | Very wide |

## Design File Requirements

### Master File Strategy
Create at largest needed size, scale down:
- **Optimal master:** 7632 × 6480 px (Redbubble max)
- **Format:** PNG with transparency
- **Color:** RGB (sRGB profile)
- **DPI:** 300 for max flexibility

### Platform-Specific Sizes

**T-Shirts (DTG):**
| Platform | Dimensions | DPI |
|----------|------------|-----|
| Printful | 4500 × 5400 | 150+ |
| Printify | 4500 × 5400 | 300 |
| Amazon Merch | 4500 × 5400 | 300 |

**Mugs:**
| Platform | Dimensions |
|----------|------------|
| Printful | 4500 × 1100 |
| Printify | 2130 × 900 |

**All-Over Print:**
| Platform | Dimensions |
|----------|------------|
| Printful | 6900 × 10200 |
| Printify | Provider-specific |

## Workflow: Design to Multi-Platform

```
1. CREATE MASTER
   - 7632 × 6480 px PNG transparent
   - RGB sRGB color
   
2. GENERATE VARIANTS
   - Printful apparel: 4500 × 5400
   - Mugs: 4500 × 1100
   - Amazon Merch: 4500 × 5400
   - Redbubble: Upload master
   
3. CREATE MOCKUPS
   - 5-8 colors × 3 angles minimum
   - Use AI tools or Placeit
   
4. WRITE LISTINGS
   - Platform-optimized titles
   - Keywords/tags per platform
   - Calculate pricing with fees
   
5. UPLOAD
   - Printful → Etsy integration
   - Direct to Amazon Merch
   - Redbubble (auto-generates products)
```

## Common Pain Points & Solutions

### Color Accuracy
**Problem:** RGB looks vibrant, prints dull
**Solution:** 
- Design with slightly more saturated colors
- Order samples before launch
- DTG on dark shirts especially problematic

### Transparency Issues
**Problem:** White halos, semi-transparent pixels
**Solution:**
- Check edges at 200%+ zoom
- Use hard edges, avoid anti-aliasing at boundaries
- Test PNG on colored background before upload

### Multi-Platform Management
**Problem:** 4 platforms = 4 separate uploads
**Solution:**
- Use CSV bulk upload where supported
- Printful → Etsy integration saves time
- Batch similar work together

## Pricing Formula

```
Retail Price = (Base Cost + Platform Fees + Shipping) / (1 - Desired Margin %)
```

**Example (T-shirt on Etsy via Printful):**
- Base cost: $12
- Etsy fees: ~25% of sale
- Desired margin: $8

```
Price = ($12 + $8) / (1 - 0.25) = $26.67 → round to $27
```

**Typical margins:** $5-12 per item (varies by product)

## Trend-Based Launch

### Speed Pipeline
1. Identify trend (social, events)
2. Validate (search volume, no trademark issues)
3. Rapid design (2-4 hours, simple/text-based)
4. Quick mockups (black + white tee minimum)
5. List on Amazon first (fastest indexing)
6. Check sales after 48-72 hours
7. Double down on winners, kill losers

### Trademark Safety
**Never use:**
- Team names, league names
- Celebrity names
- Movie/TV titles
- Brand names

**Check:** USPTO TESS database before designing

## Product Selection by Niche

| Niche | Best Products |
|-------|---------------|
| Gaming | Hoodies, mousepads, posters |
| Fitness | Water bottles, gym tanks, bags |
| Pets | Mugs, t-shirts, blankets |
| Quotes/Text | T-shirts, posters, stickers |
| Art | Canvas, posters, phone cases |

## Validation Before Full Launch

1. Create single product listing (black tee)
2. Single platform (Etsy or Amazon)
3. Basic mockup only
4. Monitor 7-14 days
5. If signal positive → full expansion
6. If no signal → archive or iterate
