# Etsy Selling

## Listing Structure

### Title
- **Max:** 140 characters
- **Strategy:** Front-load primary keywords
- **Readable:** Don't keyword stuff

### Tags
- **Count:** Exactly 13 allowed, USE ALL 13
- **Format:** Multi-word phrases (2-3 words) > single words
- **Include:** Synonyms, variations, long-tail

### Description
- **First 160 chars:** Show in search results
- **Strategy:** Natural keyword integration
- **Include:** Story, process, materials, sizing

### Attributes
- **Rule:** Fill ALL available for your category
- **Why:** Etsy rewards completeness

### Photos
- **Count:** Up to 10
- **Minimum:** 2000px on shortest side
- **Aspect:** 1:1 recommended
- **First image:** Thumbnail in search (optimize for CTR)

### Video
- **Length:** 5-15 seconds
- **Sound:** None (auto-plays muted)
- **Impact:** Huge ranking boost

## Fee Structure

| Fee | Amount |
|-----|--------|
| Listing | $0.20 (4-month renewal) |
| Transaction | 6.5% of sale + shipping |
| Payment Processing | 3% + $0.25 |
| Offsite Ads (>$10K) | 15% mandatory |
| Offsite Ads (<$10K) | 12% optional |
| Currency Conversion | 2.5% |

**Total typical cut:** 25%+ of sale price

## Algorithm Ranking Factors

1. **Relevance** — Query match to tags, title, attributes
2. **Listing Quality Score** — CTR, favorites, purchases
3. **Recency** — New/renewed listings get boost
4. **Customer Experience Score** — Reviews, policies, completeness
5. **Shipping Price** — Free shipping heavily favored
6. **Shop Location** — Local results for nearby buyers

## Star Seller Requirements

| Metric | Target |
|--------|--------|
| Message Response | 95% within 24 hours |
| On-Time Shipping | 95% with tracking |
| Ratings | 4.8+ average |
| Orders | 5+ orders, $300+ in 3 months |

Evaluated monthly on rolling basis.

## SEO Strategy

### Keyword Layering
1. Primary in title (front)
2. Same primary in tags
3. First line of description
4. Attributes where applicable
5. Synonyms across 13 tags

### Long-Tail Domination
- Target: "personalized leather wallet for dad"
- Avoid: "wallet" (too competitive)

### Competitor Analysis
- Study top sellers' tags (Shop by section)
- Identify gaps in their coverage
- Fill those gaps in your listings

## Pricing Strategy

### Free Shipping Psychology
- Set threshold at $35 (Etsy's magic number)
- Build shipping into product price
- Algorithm heavily favors free shipping

### Psychological Pricing
- $19.99 vs $20 still works
- $29 vs $30 feels significantly different

## Review Generation

1. **Packaging experience** — Handwritten note, branded materials
2. **Message timing** — Follow up 2-3 weeks post-delivery
3. **Recovery** — Contact unhappy customers BEFORE they review

## Seasonal Planning

| Event | List By |
|-------|---------|
| Valentine's | November |
| Easter | January |
| Mother's Day | February |
| Back to School | May |
| Halloween | July |
| Christmas | August-September |

## Growth Strategies

- **Pinterest funnel** — Pin every listing, create idea pins
- **Multi-variation listings** — Each variation ranks for different keywords
- **Digital products** — Zero marginal cost, passive income
- **Email list building** — Card in packages to personal site
- **Listing renewal** — Renew before peak times for recency boost
