# Manufacturing Compliance

## Consumer Electronics

| Region | Requirements |
|--------|-------------|
| **USA** | FCC Part 15 (EMC), UL/ETL (safety), California Prop 65 |
| **EU** | CE Marking (RED/EMC/LVD), RoHS, WEEE, Batteries Directive |
| **UK** | UKCA Marking, UK RoHS |
| **Australia** | RCM (Regulatory Compliance Mark) |
| **Canada** | ISED certification |
| **Japan** | VCCI (voluntary), PSE Mark (safety) |

**Key Tests:** EMC emissions, electrical safety, SAR (wireless near body)

## Food Contact Products

| Region | Requirements |
|--------|-------------|
| **USA** | FDA 21 CFR, California Prop 65 |
| **EU** | EC 1935/2004, EC 10/2011 (plastic), LFGB (Germany) |
| **China** | GB 4806 series |

**Key Tests:** Migration testing, heavy metals, overall migration limit

## Toys & Children's Products

| Region | Requirements |
|--------|-------------|
| **USA** | CPSIA, ASTM F963, CPSC registration, tracking labels |
| **EU** | EN 71 series, CE marking, Toy Safety Directive |
| **Canada** | CCPSA |
| **Australia** | AS/NZS ISO 8124 |

**Key Tests:** Small parts, sharp edges, flammability, lead, phthalates

## Cosmetics & Personal Care

| Region | Requirements |
|--------|-------------|
| **USA** | FDA labeling, California Prop 65, MoCRA 2022 |
| **EU** | EC 1223/2009, CPNP notification, Safety Assessment |
| **UK** | UK Cosmetics Regulation, SCPN registration |

**Key Tests:** Stability, microbiological, preservative efficacy, allergens

## Textiles & Apparel

| Region | Requirements |
|--------|-------------|
| **USA** | CPSIA (children's), Care Labeling Rule, Flammable Fabrics Act |
| **EU** | REACH, EU Textile Regulation 1007/2011 |
| **California** | Prop 65 |

**Key Tests:** Fiber content, AZO dyes, formaldehyde, flammability

## Batteries & Products with Batteries

| Requirement | Details |
|-------------|---------|
| Shipping | UN 38.3 (transport), IATA/IMDG |
| USA | UL 2054/2056 (power banks), state recycling |
| EU | Battery Directive (→ Battery Regulation 2023) |

**Key Tests:** UN 38.3 suite (altitude, thermal, shock, short circuit)

## Manufacturing Sourcing

### Domestic vs. Overseas

| Factor | China | Domestic (US/EU) | SE Asia |
|--------|-------|------------------|---------|
| Cost | Lowest | 2-5x higher | Middle |
| MOQ | 1,000-5,000+ | 100-500 | Similar to China |
| Lead Time | 30-90 days + shipping | 2-4 weeks | 45-60 days + shipping |
| IP Risk | Higher | Low | Medium |
| QC | Active management needed | Easier | Developing |
| Tariffs (US) | 7.5-25%+ | None | Lower |

### Tooling Economics

| Type | Cost Range | Lifespan |
|------|------------|----------|
| Soft (silicone) | $500-3K | 50-100 shots |
| Aluminum | $2K-10K | 1K-10K shots |
| P20 Steel | $5K-25K | 100K+ shots |
| Hardened Steel | $15K-100K+ | 500K-1M+ shots |

**Rule:** Tooling < 10% of first year's expected revenue

### MOQ Negotiation

1. Promise larger follow-up order
2. Accept higher per-unit price
3. Combine multiple products
4. Order during slow season (Q2 in China)
5. Pay for excess materials upfront
6. Use trading companies

## Quality Control

### Inspection Points
1. **Pre-Production Sample** — Approve before mass production
2. **Incoming Material** — Components meet spec
3. **In-Line** — During production (20-30%)
4. **Final Random (FRI)** — AQL sampling before ship
5. **Loading Supervision** — Verify correct goods

### AQL Standards
| Defect Type | Target |
|-------------|--------|
| Critical (safety) | 0% |
| Major (function) | AQL 2.5 |
| Minor (cosmetic) | AQL 4.0 |

## Hidden Costs

| Cost | Range |
|------|-------|
| Tooling modifications | $2K-20K |
| Testing/Certification | $5K-50K |
| QC inspections | $250-500/visit |
| Freight forwarding | $150-500/shipment |
| Customs duties | 0-25% |
| Product liability insurance | $500-3K/year |

## Production Milestones (Electronics)

| Stage | Duration | Output |
|-------|----------|--------|
| EVT (Engineering) | 4-8 weeks | 5-20 units |
| DVT (Design) | 6-12 weeks | 50-200 units |
| PVT (Production) | 4-8 weeks | 200-1000 units |
| MP (Mass) | Ongoing | Per order |
