# Amazon FBA Selling

## Listing Requirements

### Title (2025 Rules)
- **Max:** 200 characters including spaces
- **Prohibited:** ! $ { } ? (unless brand name)
- **Word repetition:** Max twice per word
- **Best practice:** Keep under 150 chars
- **Format:** Capitalize major words, use numerals

### Bullet Points
- **Recommended:** 200-250 chars per bullet
- **Max total:** 1,000 chars across all bullets
- **Count:** 5 bullets standard
- **Prohibited:** ALL CAPS, "best seller", pricing, shipping info

### Backend Search Terms
- **Limit:** 250 bytes
- **Rules:** No brand names, no ASINs, no commas needed
- **Critical:** Exceeding limit = entire field not indexed

## A+ Content (EBC)

**Eligibility:** Brand Registry required

**Module limits:**
- Basic: Up to 7 modules
- Premium: Up to 7 modules

**Image sizes:**
| Type | Dimensions |
|------|------------|
| Logo | 600 × 180 px |
| Header | 970 × 600 px |
| Standard | 970 × 300 px |
| Comparison | 150 × 300 px |

**Premium A+ eligibility:** All ASINs have Brand Story + 5 approved projects in 12 months

## Fees Structure

| Fee | Amount |
|-----|--------|
| Referral | 8-15% (category dependent) |
| FBA Fulfillment | $3-5+ (size/weight) |
| Monthly Storage | $0.87/cubic ft (Jan-Sep), $2.40 (Oct-Dec) |
| Aged Inventory | Surcharge after 181+ days |
| Inbound Placement | New fee for distributed inventory |

## PPC Advertising

### Campaign Types
- **Sponsored Products:** Keyword/ASIN targeting
- **Sponsored Brands:** Brand awareness, video
- **Sponsored Display:** Retargeting, audiences

### Key Metrics
| Metric | Formula | Target |
|--------|---------|--------|
| ACoS | Ad Spend / Ad Revenue | 15-30% mature |
| TACoS | Ad Spend / Total Revenue | Lower is better |
| Break-even ACoS | Profit margin % | Match or beat |

**Launch phase:** 40-50% ACoS acceptable for velocity

### Campaign Strategy
1. Start with Auto campaign
2. Harvest converting terms to Manual
3. Negative match non-converters
4. Optimize bids based on ACoS

## Listing Optimization

### Keyword Strategy
1. Primary keyword in title (front-loaded)
2. Secondary keywords in bullets
3. Tertiary in backend
4. Avoid repetition across fields

### Image Strategy
1. Main: Product on white, 85%+ fill
2. Infographic with features
3. Lifestyle/context shot
4. Size/scale reference
5. Packaging contents
6. Close-up details

## Common Tools

### Research
- Helium 10 (Cerebro, Magnet, X-Ray)
- Jungle Scout (Product Database, Keyword Scout)
- Keepa (price/BSR history)

### PPC
- Adtomic
- Perpetua
- Scale Insights

### Operations
- SoStocked (inventory)
- InventoryLab (accounting)
- A2X (bookkeeping)

## Launch Checklist

- [ ] High-quality images (1600px+)
- [ ] Optimized title with primary keyword
- [ ] 5 benefit-focused bullet points
- [ ] Backend keywords (250 bytes max)
- [ ] Competitive pricing
- [ ] A+ Content (if Brand Registered)
- [ ] Auto PPC campaign ready
- [ ] Inventory at Amazon FC
