---
name: Product
description: "Build, visualize, and launch products with strategy frameworks, AI imagery tools, and marketplace optimization."
---

## When to Use
- Creating products (digital SaaS or physical goods)
- Generating product mockups and photography with AI
- Optimizing listings for marketplaces (Amazon, Etsy, Shopify)
- Validating ideas and measuring product-market fit
- Pricing strategy and launch planning

## Quick Reference

| Need | File |
|------|------|
| Validate an idea | `strategy/validation.md` |
| Prioritize features | `strategy/prioritization.md` |
| Track metrics | `strategy/metrics.md` |
| AI image tools | `visuals/ai-tools.md` |
| Product photo prompts | `visuals/prompts.md` |
| Image specs by platform | `visuals/specs.md` |
| Amazon FBA | `commerce/amazon.md` |
| Etsy selling | `commerce/etsy.md` |
| Print-on-demand | `commerce/pod.md` |
| Pricing strategies | `commerce/pricing.md` |
| Manufacturing compliance | `manufacturing/compliance.md` |

## Core Workflow

**Digital Products (SaaS):**
1. Validate → `strategy/validation.md` (interviews, smoke tests)
2. Define MVP → strip to one core value proposition
3. Prioritize → `strategy/prioritization.md` (RICE scoring)
4. Launch → beta program, iterate fast
5. Measure PMF → `strategy/metrics.md` (Sean Ellis 40%+)

**Physical Products:**
1. Design → ensure DFM compliance
2. Source → `manufacturing/compliance.md` for certs by region
3. Photograph → `visuals/prompts.md` for AI shots
4. List → platform-specific files in `commerce/`
5. Launch → limited drops, scarcity mechanics

**Merchandising (logo on products):**
1. Create design at highest resolution needed
2. Use AI mockup tools → `visuals/ai-tools.md`
3. Export platform-specific sizes → `visuals/specs.md`
4. List across platforms → `commerce/pod.md`

## Critical Rules
- **Validate before building** — always test demand first
- **Platform specs matter** — wrong dimensions = rejected listings
- **Pricing includes fees** — calculate true margins after all platform cuts
- **PMF before scaling** — 40%+ "very disappointed" on Sean Ellis test
