---
name: product-spy
description: Meta-skill for finding e-commerce winning products by correlating social hype signals with marketplace competition data and preparing deployment-ready store listings. Use when users want trend scouting for dropshipping/white-label opportunities with explicit data gates and execution handoff.
homepage: https://clawhub.ai
user-invocable: true
disable-model-invocation: false
metadata: {"openclaw":{"emoji":"🕵️","requires":{"bins":["node","npx","goplaces"],"env":["TAVILY_API_KEY","GOOGLE_PLACES_API_KEY","MATON_API_KEY"],"config":[]},"note":"Requires local installation of tavily-search, goplaces, api-gateway, and at least one deployment path (woocommerce or shopify)."}}
---

# Purpose

Identify product opportunities by combining:
1. social momentum,
2. regional demand checks,
3. marketplace competition/sales signals,
4. store deployment readiness.

This is an orchestration skill. It does not guarantee profitability.

# Required Installed Skills

- `tavily-search` (inspected latest: `1.0.0`)
- `goplaces` (inspected latest: `1.0.0`)
- `api-gateway` (inspected latest: `1.0.29`)
- Deployment target:
  - `woocommerce` via `api-gateway` (supported), or
  - `shopify` (inspected latest `1.0.1`, currently under maintenance)

Install/update:

```bash
npx -y clawhub@latest install tavily-search
npx -y clawhub@latest install goplaces
npx -y clawhub@latest install api-gateway
npx -y clawhub@latest install shopify
npx -y clawhub@latest update --all
```

Verify:

```bash
npx -y clawhub@latest list
```

# Required Credentials

- `TAVILY_API_KEY` (trend and web data collection)
- `GOOGLE_PLACES_API_KEY` (regional demand proxy via `goplaces`)
- `MATON_API_KEY` (market/deployment APIs via `api-gateway`)

Preflight:

```bash
echo "$TAVILY_API_KEY" | wc -c
echo "$GOOGLE_PLACES_API_KEY" | wc -c
echo "$MATON_API_KEY" | wc -c
```

Mandatory behavior:
- Never fail silently on missing keys.
- Always return `MissingAPIKeys` with missing variables and blocked stages.
- Continue with non-blocked stages and mark output as `Partial` when needed.

# Inputs the LM Must Collect First

- `product_niche` (example: `pets`)
- `target_region` (country/city scope)
- `target_store` (`woocommerce` or `shopify`)
- `risk_tolerance` (`low`, `medium`, `high`)
- `max_cogs` (maximum source cost)
- `min_margin_target` (percentage)
- `shipping_time_limit_days`
- `ad_angle` (problem-solution, UGC demo, before-after)

Do not propose deployment before constraints are explicit.

# Tool Responsibilities

## tavily-search

Use for trend and sourcing discovery:
- find viral product mentions and trend lists,
- gather social evidence summaries,
- locate supplier listings (AliExpress/Alibaba/web catalogs),
- extract competitor storefront/product page signals.

## goplaces

Use for regional demand proxy checks:
- query related local businesses/search entities,
- compare demand-like signals across cities/regions,
- support geo-prioritization for launch/testing.

Important limitation:
- `goplaces` is a Places API interface, not direct social trend telemetry.
- Treat it as location demand context, not a standalone trend oracle.

## api-gateway

Use for structured market and store operations when connections exist:
- marketplace/analytics connectors if available in user account,
- WooCommerce product draft creation,
- optional Search Console-like enrichment if connected.

Operational constraints from inspected skill:
- requires `MATON_API_KEY`
- requires active per-app OAuth connections (`ctrl.maton.ai`)
- API key alone is not sufficient

Capability disclosure:
- `woocommerce` is explicitly listed in inspected api-gateway references.
- `shopify` inspected skill is currently under maintenance and may be unavailable.
- `helium 10` and `jungle scout` are not explicitly listed as native api-gateway app names in the inspected version.

# Canonical Causal Signal Chain

1. `Trend Scan (tavily-search)`
- discover products with strong recent social momentum.
- candidate example pattern: `"TikTok made me buy it" + niche + last 7 days`.

2. `Social Evidence Scoring`
- score each candidate by recency, source diversity, and repeat mention frequency.
- require at least 2 independent sources for shortlisting.

3. `Regional Demand Check (goplaces)`
- check target-region relevance proxies.
- prioritize products with cross-region consistency, not one-off spikes.

4. `Market Data Gate (api-gateway)`
- attempt sales/competition metrics via connected provider.
- if Helium 10/Jungle Scout path is unavailable, trigger explicit gate message and fallback mode.

Required gate format:
- `DataGateStatus`: `available` or `blocked`
- `Reason`: missing key / missing connection / provider unsupported
- `Action`: exact remediation steps and link

If user requests Helium 10 discount onboarding:
- include user-provided affiliate URL when available,
- otherwise use placeholder explicitly as user action item: `[HELIUM10_LINK_OR_COUPON]`.

If user requests Jungle Scout onboarding:
- include user-provided affiliate URL when available,
- otherwise use placeholder: `[JUNGLESCOUT_LINK_OR_COUPON]`.

5. `Sourcing Check (tavily-search)`
- find supplier options,
- compare estimated COGS and shipping windows,
- flag risky supplier signals (unclear shipping, no ratings, poor consistency).

6. `Deployment`
- WooCommerce path: create product draft via api-gateway `woocommerce` endpoints.
- Shopify path: if unavailable/maintenance, emit blocked deployment status and WooCommerce/manual fallback package.

7. `Creative Output`
- generate product listing copy,
- generate one TikTok ad script matched to selected angle.

# Output Contract

Always return:

- `TrendCandidates`
  - shortlisted products
  - evidence score and sources

- `MarketCheck`
  - competition/sales insight
  - DataGate status and provider path used

- `SourcingTable`
  - supplier options
  - estimated COGS
  - shipping-time estimate
  - risk notes

- `StoreDraft`
  - title
  - product description
  - key benefits
  - price suggestion
  - draft payload for `woocommerce` or `shopify` (if available)

- `TikTokAdScript`
  - hook (first 2 seconds)
  - demo beats
  - CTA

- `NextActions`
  - exact steps to publish and test

# Quality Gates

Before final output, verify:
- trend evidence is recent and source-backed
- product economics satisfy user constraints
- deployment path is real (not assumed)
- unsupported integrations are explicitly disclosed
- missing keys/connections are clearly reported

If any gate fails, return `Needs Revision` with missing evidence/dependency list.

# Failure Handling

- Missing `TAVILY_API_KEY`: return `MissingAPIKeys`, skip trend/sourcing web stages, ask for seed product URLs.
- Missing `GOOGLE_PLACES_API_KEY`: return `MissingAPIKeys`, skip regional-demand stage.
- Missing `MATON_API_KEY`: return `MissingAPIKeys`, skip gateway market/deployment stages.
- Missing api-gateway app connection (HTTP 400): keep pipeline running in analysis mode and provide connection setup steps.
- Shopify unavailable (maintenance): mark deployment as blocked and provide WooCommerce/manual import fallback.
- Helium 10/Jungle Scout unavailable via gateway: disclose unsupported provider path and continue with proxy competition analysis.

# Guardrails

- Never claim a product is guaranteed to win.
- Never fabricate sales volume, margins, or review counts.
- Never hide blocked provider paths.
- Keep recommendations tied to observed evidence and declared assumptions.
