---
name: Product Manager
description: Build products users love with discovery, prioritization, roadmapping, and cross-functional leadership.
metadata: {"clawdbot":{"emoji":"🎯","os":["linux","darwin","win32"]}}
---

# Product Management Rules

## Discovery
- Talk to users weekly — not just at project kickoff
- Watch behavior, don't just collect opinions — users say one thing, do another
- Problem validation before solution validation — are we solving the right thing?
- Jobs to be done: what's the user trying to accomplish?
- Competitors show what's possible, not what to copy

## Prioritization
- Impact vs effort is a starting point, not the answer
- Say no more than yes — focus is a feature
- Urgent vs important: stakeholder pressure isn't priority
- Stack rank ruthlessly — "everything is P1" means nothing is
- Revisit priorities when context changes — quarterly at minimum

## Roadmapping
- Outcomes over outputs — what will change, not what we'll build
- Time horizons: now (committed), next (planned), later (possible)
- Communicate uncertainty honestly — roadmaps aren't promises
- Dependencies surfaced early — blocked work wastes everyone's time
- Update when reality changes — stale roadmaps destroy trust

## Requirements
- User stories: who, what, why — not how
- Acceptance criteria define done — ambiguity creates rework
- Edge cases addressed upfront — not discovered in QA
- Scope creep is the enemy — good enough now beats perfect later
- Technical constraints are real — work with engineering, not around them

## Working with Engineering
- Context over directives — explain why, not just what
- Tradeoffs are collaborative decisions
- Spec before sprint, not during — no designing on the fly
- Protect focus time — meetings kill flow
- Trust their estimates, push back on scope not time

## Working with Design
- Research together, don't hand off briefs
- Critique the work, not the designer
- Design reviews with users, not just stakeholders
- Mobile and edge cases early — not afterthoughts
- Design system enables speed — support it

## Stakeholder Management
- Regular updates prevent surprise requests
- Data calms opinion battles
- Explain trade-offs, don't just defend decisions
- Feedback channels prevent end-runs — make input easy
- Executive sponsors for big initiatives

## Metrics
- One north star metric, 2-3 supporting
- Leading indicators for early signal — don't wait for lagging
- Dashboards should prompt questions, not just display numbers
- Vanity metrics feel good, don't drive decisions
- A/B test when data beats intuition

## Launch
- Soft launch catches problems before scale
- Success criteria defined before launch — not after
- Rollback plan before rollout
- Cross-functional checklist: docs, support, marketing
- Post-launch review: what worked, what didn't

## Common Mistakes
- Feature factory: shipping without learning
- Overspeccing: killing engineering autonomy
- Consensus seeking: decisions by committee
- Ignoring qualitative: data alone misses why
- Roadmap as backlog: detail everything, commit nothing
