---
name: product-launch
description: Plan and execute a product launch for a solopreneur business. Use when launching a new product, feature, service, or major update. Covers pre-launch strategy, building anticipation, launch day execution, post-launch momentum, and measuring launch success. Trigger on "product launch", "launch my product", "launch strategy", "how to launch", "launch plan", "go-to-market launch".
---

# Product Launch

## Overview
A launch is your best opportunity to create momentum, generate buzz, and acquire customers at scale in a short window. Most solopreneurs launch quietly and wonder why no one notices. This playbook shows you how to launch with impact — turning launch day into launch week, and launch week into sustained growth.

---

## Step 1: Define Your Launch Goals

A launch without clear goals is just noise. Before planning tactics, answer:

**What does success look like?**
- Revenue target? (e.g., $10K in first month)
- User/customer target? (e.g., 100 signups, 20 paying customers)
- Awareness target? (e.g., 10K impressions, 500 email signups)
- Press/social mentions? (e.g., featured on Product Hunt, 3 industry blogs)

**Pick 1-2 primary goals.** Everything in your launch plan should ladder up to these.

**Launch goal → Tactic mapping:**
- Revenue goal → Pre-sales, launch discounts, urgency
- User growth → Free tier, viral loops, community activation
- Awareness → PR outreach, influencer partnerships, paid ads
- Validation → Beta program, early adopter interviews, feedback loops

---

## Step 2: Build Your Pre-Launch Strategy (4-6 Weeks Out)

Great launches are won in the pre-launch phase. You build momentum BEFORE launch day, so when you hit "go," there's an audience ready to act.

**Pre-launch timeline:**

### 6 Weeks Before Launch: Build Your Waitlist
Create a simple landing page with:
- Headline stating the problem + solution
- Bullet points of key benefits
- Email signup form ("Join the waitlist — launching [date]")
- Social proof if you have any (testimonials from beta users, logos, early results)

Drive traffic to the waitlist from:
- Your existing email list ("something new coming — sign up to get early access")
- Social media (tease the launch, link to waitlist)
- Relevant communities (Reddit, Slack, forums — if allowed, or via helpful engagement)

**Goal:** 50-200 waitlist signups by launch (or 10x your target customer count).

### 4 Weeks Before Launch: Create Launch Content
Prepare content to go live on launch day and the week after:
- Launch blog post (the story, the problem, the solution, the demo)
- Demo video (2-3 min walkthrough showing the product in action)
- Social posts for launch week (7-10 posts across platforms)
- Email sequence for waitlist (3 emails: 1 week before, launch day, 3 days after)
- FAQ or help docs (so people can self-serve questions)

**Rule:** All content should be DONE 1 week before launch. Launch week is for execution, not creation.

### 2 Weeks Before Launch: Seed Early Reviews
Reach out to:
- 5-10 people in your network who would be ideal customers
- Ask them to try the product early (give them beta access or a preview)
- Request honest feedback + a testimonial if they like it
- If appropriate, ask if they'd share on launch day

**Why this matters:** Social proof on day 1 builds credibility. "Just launched!" with zero reviews = risky click. "Just launched — here's what early users are saying" = trust.

### 1 Week Before Launch: Notify Your Audience
Send an email to your list and post on social:
- "Launching [Product] in 7 days"
- Brief reminder of what it does
- Exclusive launch offer or bonus (e.g., "First 100 customers get 30% off")
- CTA: "Mark your calendar" or "Reply with questions"

**Goal:** Build anticipation. Prime people to act on launch day.

---

## Step 3: Launch Day Execution

Launch day is a coordinated push across all channels. Treat it like an event, not a quiet announcement.

**Launch day checklist (complete in this order):**

- [ ] **8 AM:** Publish launch blog post on your site
- [ ] **8:30 AM:** Send launch email to waitlist ("We're live! Here's what's new.")
- [ ] **9 AM:** Post on Product Hunt (if relevant — tech/SaaS products perform well here)
- [ ] **9:15 AM:** Post on Twitter/X (thread format works best — announce, explain value, demo link, ask for RT)
- [ ] **9:30 AM:** Post on LinkedIn (longer post with story + value + CTA)
- [ ] **10 AM:** Post in 2-3 relevant communities (Reddit, Slack, Discord — add value, don't spam)
- [ ] **12 PM:** Respond to every comment, reply, and question across all channels
- [ ] **6 PM:** Send launch email to your main email list (not just waitlist — your full audience)
- [ ] **Throughout the day:** Engage on social, thank supporters, amplify user posts

**Launch day content structure (social posts):**
```
HOOK: "Today's the day — we're launching [Product]!"

PROBLEM: "We built this because [specific pain point we kept hearing]."

SOLUTION: "Here's what it does: [3 key features or benefits]."

DEMO: "See it in action → [link to demo video or site]"

CTA: "Try it free / Grab the launch discount / Let me know what you think"
```

**Pro tip:** Schedule posts in advance so you're not scrambling. Use Buffer, Hootsuite, or native platform scheduling.

---

## Step 4: Launch Week Momentum (Days 2-7)

Launch day is just the start. Most solopreneurs go quiet after day 1 and lose all momentum. Extend the launch into a full week.

**Daily launch week content (1 post/day on social, 1-2 emails over the week):**

- **Day 2:** Share a customer testimonial or early result ("Here's what [User] said after trying it")
- **Day 3:** Behind-the-scenes content ("Why we built this / What we learned building it")
- **Day 4:** Feature deep-dive ("Here's how [Feature X] works and why it matters")
- **Day 5:** Use case or case study ("How [Customer] uses [Product] to solve [Problem]")
- **Day 6:** Objection handling ("Wondering if this is right for you? Here's who it's for — and who it's not for.")
- **Day 7:** Last call + urgency ("Launch week ends tonight — grab your [discount/bonus] before it's gone")

**Email sequence (to waitlist + main list):**
- **Launch day:** "We're live! Here's how to get started."
- **Day 3:** "Already seeing results — here's an early win from [Customer]."
- **Day 6:** "Launch offer ends in 24 hours — don't miss it."

---

## Step 5: Post-Launch Follow-Up (Week 2+)

The launch window closes, but the work continues. Now you shift from hype to retention and iteration.

**Week 2 priorities:**
- [ ] Thank everyone who supported the launch (email, DM, or public post)
- [ ] Survey early customers ("What's working? What's confusing? What should we improve?")
- [ ] Fix any critical bugs or UX issues that surfaced during launch
- [ ] Analyze launch metrics (see Step 6)
- [ ] Share a post-launch recap ("Here's what we learned from launch week")

**Week 3-4 priorities:**
- [ ] Turn early customers into case studies or testimonials
- [ ] Re-engage people who signed up but didn't convert (email: "Still on the fence? Here's what you need to know.")
- [ ] Plan next content or feature announcement to maintain momentum
- [ ] If launch went well, consider a second wave (submit to more directories, reach out to press, run ads)

---

## Step 6: Measure Launch Success

Track these metrics to evaluate how the launch performed:

| Metric | What It Tells You | How to Track |
|---|---|---|
| **Waitlist signups** | Pre-launch interest | Landing page analytics |
| **Launch day traffic** | Reach and attention | Google Analytics |
| **Conversion rate** | Traffic → signups/purchases | Analytics + CRM |
| **Revenue (if applicable)** | Immediate $ impact | Stripe/payment processor |
| **Email open/click rates** | Engagement with launch emails | Email tool (ConvertKit, Mailchimp) |
| **Social engagement** | Reach and amplification | Platform analytics (Twitter, LinkedIn) |
| **Customer feedback** | Product fit and satisfaction | Surveys, support tickets, conversations |

**Post-launch review (1 week after):**
- Did you hit your primary goal(s)?
- What worked better than expected? (do more of this)
- What underperformed? (diagnose why — messaging? channel? timing?)
- What would you do differently next launch?

**Rule:** Document your learnings. Every launch teaches you something. Write it down so you don't repeat mistakes or forget what worked.

---

## Launch Strategies by Product Type

Different products benefit from different launch strategies.

### SaaS Product Launch
- **Pre-launch:** Waitlist + beta program (get 10-20 users testing before launch)
- **Launch channels:** Product Hunt, Twitter, LinkedIn, email list
- **Launch offer:** Free trial + launch discount (30% off first year for first 100 customers)
- **Post-launch:** Onboard early users aggressively, collect feedback, iterate fast

### Info Product / Course Launch
- **Pre-launch:** Waitlist + free mini-course (5-day email course as lead magnet)
- **Launch channels:** Email list (this is #1), YouTube, social
- **Launch offer:** Early-bird pricing (20-30% off for first week)
- **Post-launch:** Deliver value to first cohort, collect testimonials, open cart periodically

### Service / Agency Launch
- **Pre-launch:** Case study from pilot client + referral outreach
- **Launch channels:** LinkedIn, email, direct outreach
- **Launch offer:** Founding client rate (discounted for first 5 clients in exchange for testimonial)
- **Post-launch:** Overdeliver for first clients, turn them into referral engines

### Physical Product Launch
- **Pre-launch:** Kickstarter or Indiegogo (if applicable) or pre-orders
- **Launch channels:** Email, Instagram, TikTok, Facebook ads
- **Launch offer:** Pre-order discount + limited edition bonus
- **Post-launch:** Fulfill orders fast, request reviews, retarget buyers with upsells

---

## Launch Mistakes to Avoid
- **Launching with zero audience.** Build a waitlist first. Launching to silence is demoralizing and ineffective.
- **Launching without a clear offer or CTA.** "We launched!" is not an offer. Tell people exactly what to do: "Sign up free", "Buy now", "Book a demo."
- **Going quiet after launch day.** Launch is a week, not a day. Sustain momentum through Day 7.
- **Overpromising during launch.** Hype is good, lies are not. Only promise what you can deliver.
- **Not following up with early users.** Your first customers are your best advocates. Nurture them.
- **Skipping the post-launch review.** If you don't analyze what worked, you'll repeat the same mistakes next time.
