# Product Analysis Framework

## Analysis Steps

### 1. Product Category Identification

Determine the primary product category:

- Electronics & Gadgets
- Fashion & Accessories
- Home & Garden
- Beauty & Personal Care
- Sports & Outdoors
- Toys & Games
- Food & Beverages
- Health & Wellness
- Tools & Home Improvement
- Jewelry & Luxury
- Baby & Kids
- Pet Supplies

### 2. Target Audience Analysis

Identify who the product is for:

| Segment | Characteristics |
|---------|-----------------|
| Budget-conscious | Price-sensitive, value-focused |
| Quality-focused | Willing to pay for durability |
| Luxury seekers | Premium, status-oriented |
| Tech-savvy | Early adopters, feature-focused |
| Eco-conscious | Sustainability priority |
| Family-oriented | Safety, practicality |
| Professionals | Business, productivity |
| Youth/Trend | Style, social proof |

### 3. Key Features Extraction

Identify 3-5 unique selling points:

- Design/Aesthetics
- Functionality/Features
- Quality/Materials
- Price/Value
- Brand/Status
- Innovation/Technology
- Sustainability
- Convenience
- Durability
- Safety

### 4. Competitive Positioning

Determine market position:

```
Budget ←→ Premium
Basic ←→ Feature-rich
Mass market ←→ Niche
Functional ←→ Aspirational
```

### 5. Visual Opportunities

Map product features to visual approaches:

| Feature | Visual Approach |
|---------|-----------------|
| Design | Clean studio, multiple angles |
| Texture | Macro detail shots |
| Size | Scale reference, in-hand |
| Usage | Lifestyle, action shots |
| Components | Exploded view |
| Benefits | Before/after, comparison |
| Specs | Infographic overlays |

### 6. Image Count Recommendation

| Complexity | Recommended Images |
|------------|-------------------|
| Simple (single item) | 3-4 images |
| Moderate (some features) | 4-6 images |
| Complex (multiple features) | 6-8 images |
| Very complex (system) | 8-10 images |

### 7. Platform Match

Recommend platform based on product:

| Product Type | Recommended Platform |
|--------------|---------------------|
| General consumer | Amazon |
| Branded/DTC | Shopify |
| Unique/Vintage | Etsy |
| Handmade | Etsy |
| China domestic | Taobao/JD/Pinduoduo |
| Electronics | Amazon/JD |
| Fashion | Shopify/Etsy |

## Analysis Output Template

```markdown
## Product Analysis

### Category
[Primary category]

### Target Audience
[Primary segment + characteristics]

### Key Selling Points
1. [Primary selling point]
2. [Secondary selling point]
3. [Tertiary selling point]

### Market Position
[Budget/Premium] + [Mass/Niche]

### Visual Strategy
[Recommended approach]

### Recommended Images
- P1: Hero shot (studio)
- P2: [Type]
- P3: [Type]
...

### Platform Recommendation
[Platform] - [reason]
```

## Questions to Ask

When product information is incomplete, ask:

1. **What is the primary benefit customers get from this product?**
2. **Who is the ideal customer?** (demographics + psychographics)
3. **What makes this product unique vs competitors?**
4. **What's the price point?** (budget/mid/premium)
5. **Are there any specific features to highlight?**
6. **What's the main use scenario?**
7. **Any compliance requirements?** (platform-specific)
