# Tech Style

Futuristic, sleek, modern aesthetic with cutting-edge feel.

## Element Combination

```json
{
  "background": "dark-gradient",
  "lighting": "precision-rgb",
  "shadows": "controlled-dramatic",
  "colorTreatment": "cool-blue-accent",
  "mood": "futuristic"
}
```

## Best For

- Electronics and gadgets
- Software and apps
- Gaming products
- Smart devices
- AI and tech services

## Prompt Keywords

```
Tech product photography, dark gradient background,
precision lighting with RGB accents, futuristic mood,
cool color grading with blue accents, sleek modern composition,
cutting-edge commercial, innovative, high-tech aesthetic
```

## Lighting Setup

- **Key light**: LED panels, cool temperature
- **Fill light**: Minimal, maintain drama
- **Accent light**: RGB colored, blue/cyan/purple
- **Background**: Dark gradient, subtle tech patterns

## Color Treatment

- White balance: Cool (6000K+)
- Saturation: Selective enhancement
- Contrast: High
- Highlights: Crisp, clean
- Shadows: Deep but detailed

## Color Schemes

| Product Type | Accent Colors |
|--------------|---------------|
| Consumer tech | Blue, cyan, white |
| Gaming | RGB, purple, green |
| AI/Software | Blue, purple, teal |
| Smart home | Warm white, amber |

## Platform Fit

| Platform | Suitability |
|----------|-------------|
| Amazon | ✅ Good |
| Shopify | ✅ Perfect |
| eBay | ✅ Good |
| Etsy | ⚠️ Niche |
| Taobao | ✅ Good |
| JD | ✅ Perfect |
| Pinduoduo | ✅ Good |

## Variations

### Tech + Studio | Clean dark background, precision lighting.

### Tech + Infographic | Tech-style callouts, modern fonts.

### Tech + Lifestyle | Modern workspace, tech environment.
