# Natural Style

Organic, eco-friendly, earthy aesthetic.

## Element Combination

```json
{
  "background": "natural-texture",
  "lighting": "natural-daylight",
  "shadows": "soft-natural",
  "colorTreatment": "earth-warm",
  "mood": "authentic"
}
```

## Best For

- Organic and natural products
- Sustainable goods
- Food and beverages
- Eco-friendly items
- Handmade crafts

## Prompt Keywords

```
Natural product photography, organic textured background,
natural daylight lighting with soft shadows, authentic earthy mood,
warm earth tone color grading, genuine and honest, eco-conscious composition,
sustainable aesthetic, wholesome, pure
```

## Lighting Setup

- **Key light**: Natural window light simulation
- **Fill light**: Reflect cards, natural bounce
- **Accent light**: Minimal, maintain authenticity
- **Background**: Natural materials, textures

## Color Treatment

- White balance: Warm natural (4500K)
- Saturation: Natural, true to life
- Contrast: Moderate
- Highlights: Soft, natural
- Shadows: Open, gentle

## Earth Tone Palette

| Product Type | Background Colors |
|--------------|-------------------|
| Organic food | Warm beige, soft brown |
| Sustainable | Sage green, natural linen |
| Handmade | Craft paper, wood tones |
| Natural care | Soft cream, stone gray |

## Platform Fit

| Platform | Suitability |
|----------|-------------|
| Amazon | ✅ Good |
| Shopify | ✅ Excellent |
| eBay | ✅ Good |
| Etsy | ✅ Perfect |
| Taobao | ✅ Good |
| JD | ✅ Good |
| Pinduoduo | ✅ Good |

## Props Suggestions

- Wood surfaces
- Linen fabrics
- Stone or marble
- Plants and greenery
- Natural fibers

## Variations

### Natural + Studio | Controlled natural look, clean background.

### Natural + Lifestyle | Real environment, authentic setting.

### Natural + Flatlay | Overhead with natural props.
