# Taobao Platform Requirements

## Overview

Taobao is China's largest C2C marketplace with unique image culture and requirements.

## Technical Specifications

| Requirement | Specification |
|-------------|---------------|
| **Main Image** | 800 x 800 pixels minimum |
| **Recommended** | 1000 x 1000 or 1200 x 1200 |
| **Aspect Ratio** | 1:1 (square) or 3:4 |
| **Format** | JPEG, PNG |
| **File Size** | Under 3 MB per image |
| **Max Images** | 15 per listing |

## Main Image Requirements

### First Image (Cover)

- Must show actual product
- Can include promotional text
- Bright, eye-catching style
- Price or promotion badges OK

### Images 2-5

- Additional angles
- Details and features
- Color variations
- Size charts

### Images 6-15 (Detail Images)

- Infographic style common
- Lifestyle images
- Detailed specifications
- Social proof

## Taobao Style Characteristics

### Visual Style

- Bright, vibrant colors
- High information density
- Text overlays common
- Promotional elements OK
- Emoji and icons acceptable

### Information Density

Taobao shoppers expect:
- Multiple product angles
- Detailed specifications
- Size guides
- Material information
- Usage instructions
- Customer photos

## Image Categories

### 主图 (Main Images)

First 5 images in gallery:
- Eye-catching
- Clear product display
- Key selling points
- Promotional info

### 详情页 (Detail Page Images)

Long-form content:
- Product story
- Feature breakdown
- Quality proof
- Comparisons
- Social proof

### 白底图 (White Background)

- Required for some categories
- Used for platform features
- Clean product isolation

## Common Taobao Image Types

| Type | Description |
|------|-------------|
| 场景图 | Lifestyle/context scene |
| 细节图 | Detail close-ups |
| 规格图 | Size/specifications |
| 对比图 | Comparison images |
| 实拍图 | Real photography |
| 模特图 | Model shots |
| 包装图 | Packaging images |

## Mobile Optimization

- Taobao is 90%+ mobile
- Vertical images perform well
- Text must be readable on phone
- Fast loading critical

## Best Practices

### For International Sellers

1. Use Chinese text for descriptions
2. Adapt to local aesthetic preferences
3. Include detailed size charts (Asian sizing)
4. Show multiple color options
5. Build trust with detailed info

### Image Strategy

```
Image 1: Hero + promotion badge
Image 2-3: Main angles (white background)
Image 4-5: Key features/benefits
Image 6-10: Detailed infographics
Image 11-15: Lifestyle + social proof
```

## Prohibited Content

- Counterfeit branding
- Misleading claims
- Inappropriate content
- Contact information outside platform
- Links to external sites
