# Shopify Store Image Requirements

## Overview

Shopify is flexible with product images, allowing for brand expression while maintaining professionalism.

## Technical Specifications

| Requirement | Specification |
|-------------|---------------|
| **Minimum Size** | 800 x 800 pixels |
| **Recommended** | 1024 x 1024 or 2048 x 2048 |
| **Aspect Ratio** | 1:1 (square) or 4:3 |
| **Format** | JPEG, PNG, WebP |
| **Color Mode** | sRGB |
| **File Size** | Under 20 MB |

## Image Types

### Main Product Image

- Clean, professional presentation
- Can be white background or branded
- Should clearly show the product
- Consistent style across all products

### Lifestyle Images

- Highly recommended for Shopify
- Show product in natural use
- Build emotional connection
- Support brand positioning

### Detail Shots

- Materials and textures
- Quality indicators
- Features and functionality
- Craftsmanship highlights

## Shopify-Specific Features

### Image with Text Overlay

Shopify supports text on images:
- Promotional badges
- Feature callouts
- Pricing (for sales)

### Variant Images

- Show each color/size variation
- Consistent angles across variants
- Help customers visualize options

### Gallery Best Practices

```
Recommended order:
1. Main product image (hero)
2. Lifestyle image 1
3. Lifestyle image 2
4. Detail/feature shot
5. Additional angles
6. Size/scale reference
7. Packaging (if relevant)
```

## Theme Considerations

| Theme Type | Image Recommendation |
|------------|---------------------|
| Minimal | Clean, white background |
| Lifestyle | Contextual, environmental |
| Bold | High contrast, vibrant |
| Editorial | Magazine-quality, artistic |

## Mobile Optimization

- 50%+ of Shopify traffic is mobile
- Ensure text is readable on small screens
- Test images at thumbnail size
- Consider vertical images for mobile

## Best Practices

### Consistency

- Same background across products
- Consistent lighting style
- Uniform editing approach
- Branded color grading

### Quality

- Professional photography
- Proper lighting
- Sharp focus
- Accurate colors

### Brand Building

- Develop signature style
- Use consistent props
- Maintain brand colors
- Tell brand story

## Shopify vs Amazon

| Aspect | Amazon | Shopify |
|--------|--------|---------|
| Background | White required | Flexible |
| Text on image | Not allowed on main | Allowed |
| Lifestyle | Additional only | Any position |
| Style | Standardized | Branded |

## Apps & Tools

Recommended Shopify apps for images:
- Image optimization
- Lazy loading
- Zoom functionality
- Gallery enhancements
