# Pinduoduo Platform Requirements

## Overview

Pinduoduo (拼多多) is a value-focused e-commerce platform popular for group buying and competitive pricing.

## Technical Specifications

| Requirement | Specification |
|-------------|---------------|
| **Main Image** | 750 x 750 pixels minimum |
| **Recommended** | 800 x 800 or 1000 x 1000 |
| **Aspect Ratio** | 1:1 (square) |
| **Format** | JPEG, PNG |
| **File Size** | Under 3 MB |
| **Max Images** | 10 per listing |

## Image Requirements

### Main Image

- Clear product display
- Can include price/promotion info
- Eye-catching for feed browsing
- Value proposition clear

### Additional Images

- Product details
- Usage scenarios
- Size/specifications
- Customer reviews (screenshots)

## Pinduoduo Style Characteristics

### Value-Focused

- Price/promotion badges
- Value highlights
- Bulk deal indicators
- Group buy information

### Visual Style

- Bright, eye-catching colors
- Clear value messaging
- Promotion-focused
- Mobile-optimized

## Image Strategy

```
Image 1: Hero with value/price highlight
Image 2-3: Product angles (clean)
Image 4-5: Key features/benefits
Image 6-7: Details/close-ups
Image 8-9: Lifestyle/usage
Image 10: Call-to-action/package deal
```

## Best Practices

### For Pinduoduo Success

1. Highlight value/price clearly
2. Show product quality despite low price
3. Use promotion badges effectively
4. Make deals clear (bulk, group)
5. Mobile-first design

### Promotion Elements

- Group buy pricing
- Bulk discounts
- Limited time offers
- Flash sale badges

## Prohibited Content

- False pricing claims
- Misleading promotions
- Low quality images
- External contact info
