# JD.com Platform Requirements

## Overview

JD.com (京东) is China's premium B2C e-commerce platform focusing on authenticity and quality.

## Technical Specifications

| Requirement | Specification |
|-------------|---------------|
| **Main Image** | 800 x 800 pixels minimum |
| **Recommended** | 1000 x 1000 or 1200 x 1200 |
| **Aspect Ratio** | 1:1 (square) |
| **Format** | JPEG, PNG |
| **File Size** | Under 3 MB |
| **Max Images** | 15 per listing |

## Image Requirements

### Main Image (主图)

- Clean, professional presentation
- White or light background preferred
- Product should be prominent
- No excessive text or watermarks
- Quality presentation expected

### Additional Images

- Multiple angles required
- Detail close-ups expected
- Specification images
- Packaging images
- Brand authorization (if applicable)

## JD Style Characteristics

### Professional Standard

- High-quality photography
- Clean, organized layouts
- Clear product information
- Authentic representation
- Brand-consistent styling

### Detail Page (详情页)

Structured sections:
1. Product overview
2. Key features
3. Specifications
4. Quality certificates
5. Usage instructions
6. After-sales service

## Image Strategy

```
Image 1: Clean hero shot (white background)
Image 2-3: Additional angles
Image 4-5: Key features/details
Image 6-8: Specifications/infographic
Image 9-11: Lifestyle/context
Image 12-15: Packaging/brand/certificates
```

## Category Requirements

### Electronics

- Authentic product certification
- Serial number visibility
- Warranty information
- Technical specifications

### Beauty & Personal Care

- Ingredient lists
- Usage instructions
- Authenticity verification
- Expiration date visible

### Fashion

- Size charts (Asian sizing)
- Material composition
- Multiple color options
- Model shots (optional)

## Best Practices

### For JD Success

1. Maintain high image quality
2. Include detailed specifications
3. Show authenticity proof
4. Professional presentation
5. Complete product information

### Prohibited Content

- Misleading information
- Low quality images
- Contact information outside platform
- External website links
- Inappropriate content
