# Etsy Platform Requirements

## Overview

Etsy specializes in handmade, vintage, and craft supplies with a focus on authenticity and storytelling.

## Technical Specifications

| Requirement | Specification |
|-------------|---------------|
| **Minimum Size** | 760 x 760 pixels |
| **Recommended** | 2000 x 2000 pixels |
| **Aspect Ratio** | 1:1 (square) or 4:3 |
| **Format** | JPEG, PNG |
| **Max Images** | 10 per listing |

## Etsy Image Culture

### Authenticity

- Show handmade process
- Include maker when relevant
- Behind-the-scenes valued
- Imperfection can be charming

### Lifestyle Focus

- Products in natural settings
- Show scale and use
- Storytelling through images
- Emotional connection

## Image Types

### Main Image

- Clear product display
- Can be lifestyle or studio
- Should be eye-catching in search
- Consistent shop style

### Process Images

- Work in progress
- Materials and tools
- Maker at work
- Handmade authentication

### Lifestyle Images

- Product in use
- Styled settings
- Gift presentation
- Seasonal contexts

### Detail Images

- Materials close-up
- Craftsmanship details
- Quality indicators
- Unique features

## Best Practices

### For Handmade Sellers

1. Show the making process
2. Include yourself/the maker
3. Highlight materials quality
4. Show variations (each piece unique)
5. Package beautifully

### Image Strategy

```
Image 1: Hero shot (lifestyle or clean)
Image 2: Alternate angle
Image 3: Detail/craftsmanship
Image 4: In use/lifestyle
Image 5: Materials/process
Image 6: Size reference
Image 7: Packaging
Image 8-10: Additional lifestyle or details
```

## Etsy-Specific Features

### Personalization

Show customization options:
- Color variations
- Monogram examples
- Custom size options
- Personalization process

### Variations

- List each color option
- Show size differences
- Material variations
- Style options

## Seasonal Considerations

- Update images for seasons
- Holiday gift presentations
- Seasonal styling
- Gift packaging options

## Prohibited Content

- Stock photography (for handmade)
- Misleading representations
- Items not made by seller
- Mass-produced items
