# eBay Platform Requirements

## Technical Specifications

| Requirement | Specification |
|-------------|---------------|
| **Minimum Size** | 500 x 500 pixels |
| **Recommended** | 1000 x 1000 or larger |
| **Aspect Ratio** | 1:1 (square) recommended |
| **Format** | JPEG, PNG, TIFF, BMP, GIF |
| **Max Images** | 12 free, up to 24 for some categories |

## Image Requirements

### Main Image

- Show the actual item for sale
- No watermarks or text overlays
- No borders or frames
- Professional presentation recommended

### Additional Images

- Show different angles
- Include close-ups of details
- Show any flaws or wear (for used items)
- Include packaging if relevant

## Categories

### New Items

- Professional product photography
- White or clean background
- Multiple angles
- Detail shots

### Used Items

- Honest representation of condition
- Clear photos of any damage
- Actual photos (not stock images)
- Show serial numbers if relevant

## Best Practices

### For Better Sales

1. Use all 12 free image slots
2. Show item from all angles
3. Photograph actual item (not stock)
4. Good lighting is critical
5. Show any flaws clearly

### Image Order

```
Image 1: Best angle (front/main view)
Image 2: Back/rear view
Image 3: Side views
Image 4-6: Details and features
Image 7-8: Any flaws (for used)
Image 9-10: Accessories/packaging
Image 11-12: Size reference or additional
```

## Prohibited Content

- Stock photos for used items
- Misleading angles
- Hidden defects
- Watermarks with contact info
- Links to external sites
