# Amazon Platform Requirements

## Main Image Requirements

### Technical Specifications

| Requirement | Specification |
|-------------|---------------|
| **Size** | Minimum 1000 x 1000 pixels |
| **Recommended** | 1600 x 1600 or larger (for zoom) |
| **Aspect Ratio** | 1:1 (square) |
| **Background** | Pure white RGB(255, 255, 255) |
| **Format** | JPEG (preferred), PNG, TIFF |
| **Color Mode** | sRGB recommended |
| **File Size** | Under 10 MB |

### Content Requirements

✅ **DO**:
- Show the actual product
- Fill 85%+ of the frame
- Use professional lighting
- Show product clearly
- Use high resolution

❌ **DON'T**:
- Add text or logos
- Add watermarks
- Add props not included with product
- Show mannequins (for clothing, use flat lay or ghost mannequin)
- Add borders or frames
- Use lifestyle backgrounds

## Additional Images

### Allowed Content

Images 2-9 can include:

1. **Angle variations** - Different perspectives
2. **Detail close-ups** - Materials, textures, features
3. **Lifestyle images** - Product in use
4. **Infographics** - Features, specs, benefits
5. **Comparison charts** - Size, features
6. **Packaging** - What's included
7. **Dimensions** - Size reference

### Infographic Guidelines

- Text must be legible
- Keep it professional
- Don't make false claims
- Include only verifiable information

### Lifestyle Image Guidelines

- Show product in natural use
- Maintain professional quality
- Model releases if faces visible
- No inappropriate content

## Category-Specific Requirements

### Clothing & Accessories

| Image Type | Requirement |
|------------|-------------|
| Main | Flat lay or ghost mannequin |
| Additional | Can show on model |
| Jewelry | White or light gray allowed |

### Electronics

- Main: Product only, no accessories unless included
- Additional: Can show connectivity, usage
- Screens: Should be lit/on if relevant

### Beauty & Personal Care

- Show packaging clearly
- Include size/volume visible
- Can show product texture/swatches

### Home & Kitchen

- Show scale clearly
- Can include complementary items (not included)
- Lifestyle images perform well

## Image Order Strategy

```
Image 1: Main product (white background) - REQUIRED
Image 2: Angle variation (white background)
Image 3: Detail/close-up (white background)
Image 4: Lifestyle (in use)
Image 5: Infographic (features/benefits)
Image 6: Comparison or size reference
Image 7: Packaging/what's included
Image 8-9: Additional lifestyle or details
```

## Quality Checklist

Before submitting:

- [ ] Main image on pure white background
- [ ] Product fills 85%+ of frame
- [ ] Minimum 1000x1000 pixels
- [ ] High resolution, sharp focus
- [ ] Professional lighting
- [ ] No prohibited elements on main image
- [ ] Accurate color representation
- [ ] All images same product

## Common Rejection Reasons

1. Non-white background on main image
2. Product too small in frame
3. Blurry or low resolution
4. Watermarks or text on main image
5. Wrong product shown
6. Inappropriate content

## Best Practices

### Conversion Optimization

1. **Use all 9 image slots** - More images = more information = higher conversion
2. **Lead with clarity** - Main image should be instantly recognizable
3. **Show scale** - Help customers understand size
4. **Address objections** - Use images to answer common questions
5. **Show quality** - Detail shots build confidence

### A+ Content

For brand registered sellers:
- A+ Content allows richer images
- Comparison charts
- Brand storytelling
- Enhanced product descriptions
