# Scene Guide

Scene types define the background, context, and composition approach.

## Scene Types

### Studio

**Description**: Pure white or gradient background with professional studio lighting.

**Best For**:
- Main product images
- Platform compliance (Amazon, etc.)
- Clean catalog presentation

**Prompt Elements**:
```
Professional studio photography, pure white background RGB(255,255,255),
even studio lighting, no distractions, product isolation,
commercial catalog quality
```

**Image Count**: 1-3

---

### Lifestyle

**Description**: Product in natural use environment with authentic context.

**Best For**:
- Additional images
- Emotional connection
- Showing scale and use

**Prompt Elements**:
```
Lifestyle photography, natural environment, product in use,
authentic setting, natural lighting, relatable scenario,
aspirational lifestyle
```

**Common Settings**:
- Home interior (living room, bedroom, kitchen)
- Outdoor (park, street, nature)
- Workspace (office, desk, studio)
- Social (cafe, restaurant, gathering)

**Image Count**: 2-5

---

### Contextual

**Description**: Product in staged environment that suggests use without full lifestyle scene.

**Best For**:
- Home goods
- Furniture
- Decor items
- Context without complexity

**Prompt Elements**:
```
Contextual product photography, staged environment,
suggestive setting, product placement, complementary background,
staged but natural
```

**Examples**:
- Watch on wooden desk with subtle props
- Shoes on urban surface
- Bag on marble surface with accessories

**Image Count**: 2-4

---

### Exploded

**Description**: Component breakdown showing internal structure or assembly.

**Best For**:
- Electronics
- Multi-part products
- Products with notable internal features
- Assembly demonstration

**Prompt Elements**:
```
Exploded view photography, component breakdown,
individual parts separated, assembly visualization,
technical product photography, feature highlighting
```

**Approaches**:
- True exploded (parts separated)
- Callout style (features highlighted)
- Layer view (peek inside)

**Image Count**: 3-6

---

### Comparison

**Description**: Before/after or product vs alternatives visualization.

**Best For**:
- Problem/solution products
- Upgrade demonstrations
- Size comparisons
- Efficacy demonstrations

**Prompt Elements**:
```
Comparison photography, before and after,
side by side visualization, contrast demonstration,
transformation visualization
```

**Types**:
- Before/After split
- Product vs generic
- Size comparison
- Feature comparison grid

**Image Count**: 2-4

---

### Infographic

**Description**: Product with text overlays, callouts, and information graphics.

**Best For**:
- Feature explanation
- Spec highlights
- Usage instructions
- Benefit communication

**Prompt Elements**:
```
Infographic style photography, text overlays,
feature callouts, information graphics,
annotated product image, visual explanation
```

**Elements**:
- Product as base
- Text callouts
- Icons and symbols
- Measurement lines
- Benefit highlights

**Image Count**: 2-5

---

## Scene Selection Guide

| Product Category | Primary Scene | Secondary Scene |
|------------------|---------------|-----------------|
| Electronics | Studio | Exploded/Infographic |
| Fashion | Lifestyle | Contextual |
| Home goods | Lifestyle | Contextual |
| Beauty | Studio | Lifestyle |
| Jewelry | Studio/Luxury | Contextual |
| Sports | Lifestyle | Bold studio |
| Tools | Studio | Exploded/Infographic |
| Food | Studio | Natural/Lifestyle |
| Baby | Soft studio | Lifestyle |

---

## Composition Guidelines

### Rule of Thirds
Place product at intersection points for dynamic composition.

### Leading Lines
Use environmental lines to guide eye to product.

### Negative Space
Leave breathing room, especially for platform compliance.

### Scale Reference
Include subtle scale indicators when size is important.

### Multiple Angles
Show product from front, 45°, side, top, and detail.
