# Product Hunt for Competitive Research

## What PH Data Actually Tells You

### Useful Signals
| Signal | What It Means |
|--------|---------------|
| Comment sentiment | Real user feedback (complaints = your opportunities) |
| "I wish it had..." patterns | Feature gaps to exploit |
| Maker response time | Team customer focus |
| Upvote velocity (not total) | Launch execution quality |
| Pricing in comments | Market positioning data |

### Misleading Signals
| Signal | Why It's Misleading |
|--------|---------------------|
| Total upvotes | Often gamed, doesn't correlate with revenue |
| "Product of the Day" | 80%+ dead within 2 years |
| High rank + low comments | Likely vote manipulation |
| Category leadership | PH audience ≠ your actual market |

## Research Tasks

### Competitor Launch Analysis
1. Find their last 5 launches
2. Note timing (day, time, how often)
3. Read all comments — what questions do users ask?
4. Identify complaints and feature requests
5. Analyze their maker comment structure

### Category Deep Dive
1. Search your category (last 6 months)
2. Sort by upvotes — what's the ceiling?
3. Read top 10 products' comments
4. Identify common patterns in successful taglines
5. Note what hunters cover this space

### Pre-Launch Reconnaissance
Before YOUR launch:
1. Last 20 products in category
2. What worked? (Good engagement, comments)
3. What flopped? (Low engagement despite upvotes)
4. Who are the top hunters for this space?
5. What day/time did successful ones launch?

## Limitations to Remember

**PH Audience Bias:**
- Heavily indie hackers, designers, early adopters
- NOT enterprise buyers, mass market consumers
- English-language, US-timezone skewed
- Tech bubble — what excites PH may bore the world

**Data You Won't Find:**
- Actual conversion rates (upvotes ≠ signups ≠ revenue)
- Churn rates post-launch
- Real business metrics
- Whether the maker has other revenue sources
