# Product Hunt Hunting Guide

## Finding Products Worth Hunting

### Sources to Monitor
- Twitter/X indie hacker communities (#buildinpublic)
- Reddit: r/SideProject, r/startups, r/InternetIsBeautiful
- Hacker News "Show HN" posts
- GitHub trending repos becoming products
- Discord/Slack communities (IndieHackers, WIP, etc.)

### Qualification Checklist
- [ ] Product actually works (not vaporware)
- [ ] Not already hunted (check PH search thoroughly)
- [ ] Maker is responsive and available on launch day
- [ ] Assets are prepared (video, gallery, logo)
- [ ] Maker understands they need to engage in comments

## Pre-Hunt Coordination

**Always coordinate with the maker:**
1. Confirm launch date/time
2. Request all assets in advance
3. Verify maker will be online for 24 hours
4. Agree on tagline and description
5. Set expectations on your role

**Red flags to avoid:**
- Maker wants to launch "whenever"
- No video or GIF available
- Maker doesn't respond quickly
- Product has obvious bugs

## Writing Great Hunt Copy

### Tagline (60 chars)
- Specific value prop, not generic
- What does it DO, not what it IS
- No "revolutionary", "AI-powered", "best"

**Good:** "Turn any screenshot into a Figma component"
**Bad:** "The revolutionary AI-powered design tool"

### First Comment Strategy
- Personal story: why YOU believe in this product
- What problem it solves that you care about
- Specific feature that impressed you
- Question for the maker to spark discussion

## Building Hunter Reputation

| Action | Reputation Impact |
|--------|------------------|
| Product of the Day | ++++ |
| Top 5 finish | +++ |
| Engaged maker, good comments | ++ |
| Product gets Featured | +++ |
| Product flopped, low engagement | -- |
| Hunted without coordination | --- |

**Quality over quantity:**
- 5 successful hunts > 20 mediocre ones
- Each flop makes your next hunt harder
- Build relationships with makers before hunting
