# Product Hunt Community Engagement

## The Unwritten Rules

1. **Day-of support matters most** — First 4-6 hours determine trajectory
2. **Comments > Upvotes for credibility** — Thoughtful comments build reputation
3. **Makers who reply to EVERY comment win** — Shows responsiveness
4. **Supporting others first = they support you later** — Strong reciprocity culture
5. **24-hour window is everything** — After that, products disappear
6. **12:01 AM PT launch** — Gives full 24 hours in US business day

## Comment Strategy

### DO:
- Reference something SPECIFIC ("The Notion integration handles X well because...")
- Ask genuine questions you want answered
- Share relevant personal experience
- Offer constructive feedback with kindness
- Engage in threaded discussions

### DON'T:
- Generic "Congrats!" or "Looks great!"
- Copy-paste comments across products
- Self-promote in others' threads
- Defensive responses to criticism
- Ask for upvotes anywhere

### Comment Template That Works
```
[Specific observation]: "I like how [feature] handles [problem]"
[Genuine question]: "Curious how you're thinking about [edge case]?"
[Personal context]: "I've been using [competitor] for this — what's the migration path?"
```

## Behaviors That Get Penalized

### Detected Automatically
| Behavior | Detection Method |
|----------|------------------|
| Same IP/device upvotes | Vote fingerprinting |
| Burst from new accounts | Astroturfing pattern |
| Upvote circles | Graph analysis (same 50 people) |
| External vote groups | PH monitors Slack/Discord |
| VPN voting | Sophisticated detection |

### Consequences
- **Shadowban:** Your upvotes don't count, you don't know
- **Reduced discoverability:** Product deprioritized
- **Account trust drop:** Future launches suffer
- **Permanent blacklist:** Extreme cases

## Building Authentic Presence

### Daily Habits
- Upvote 2-3 products you genuinely like
- Leave 1-2 thoughtful comments
- Reply to discussions you're in
- Follow makers building interesting things

### Before Your Launch
- Build presence 2-3 months in advance
- Support others' launches authentically
- Connect with hunters in your space
- Be known for helpful comments, not just upvotes

### Long-Term Reputation
- Consistent, authentic engagement > launch day blitz
- Help others without expecting return
- Be the person who gives useful feedback
- Quality of comments > quantity of upvotes
