---
name: Product Hunt
slug: product-hunt
version: 1.0.0
description: "Launch, hunt, and research products on Product Hunt with timing, assets, engagement, and anti-manipulation practices."
metadata: {"clawdbot":{"emoji":"🚀","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## Quick Reference

| Topic | File | Key Trap |
|-------|------|----------|
| Launch execution | `launch.md` | Wrong launch time (not 12:01 AM PT) |
| Hunting products | `hunting.md` | Hunting without maker coordination |
| Competitive research | `research.md` | Treating upvotes as validation |
| Engagement rules | `engagement.md` | Vote manipulation detection |

## Critical Launch Traps

**Timing:**
- Launch window: **12:01 AM to 11:59 PM Pacific Time** — not your timezone
- Best days: Tuesday-Thursday. Mondays = catch-up mode, Fridays = weekend mode
- First 4-6 hours determine ranking trajectory — front-load your promotion

**Assets (exact specs matter):**
- Gallery images: 1270x760px — first image is EVERYTHING
- GIF/video dramatically outperforms static images (<30 seconds)
- Logo: 240x240px
- Tagline: 60 chars max, no buzzwords ("revolutionary", "AI-powered" = instant skip)

**Maker Comment:**
- Personal story, not corporate pitch — PH community is indie-friendly
- Why you built it, what problem you personally faced
- Update throughout the day with new info

**First Paragraph Gets Truncated:**
- Hook must be in first sentence — longer descriptions cut off in feed

## Hunter Reputation System

**Building Credibility:**
- Quality over volume — 5 great hunts > 20 mediocre ones
- Each flop damages future hunt performance
- Top hunters have followers who get notified — real distribution advantage
- Hunt without maker coordination = product has bugs on launch day

**Hunter Mechanics:**
- Anyone can post, but established hunters have amplification
- Getting "Featured" is editor's pick — massive visibility boost
- Collections extend long-tail traffic beyond launch day

## Engagement Anti-Patterns

**What Gets Detected & Penalized:**
- Multiple upvotes from same IP/device → shadowbanned votes
- Burst of upvotes from new accounts → astroturfing pattern
- Upvote circles (same 50 people always vote each other)
- External vote exchange groups (PH actively monitors Slack/Discord)
- Asking for upvotes in comment threads → public callout

**What Looks Spammy:**
- Copy-paste comments across products
- Generic "Congrats!" with no substance
- Mass DMs to makers
- Defensive/hostile responses to criticism

## Competitive Intelligence Limits

**Model Blind Spots — Don't Trust:**
- Upvotes ≠ users ≠ paying customers (zero correlation)
- 80%+ of "Product of the Day" winners are dead within 2 years
- PH audience = indie hackers, designers, early adopters — NOT enterprise
- High upvotes + low comments often = gamed launch

**Useful Signals:**
- Comment sentiment reveals real user feedback
- "I wish it had..." patterns = your opportunities
- Maker response time indicates team readiness
- Velocity curve > total upvotes (200 in 2h > 500 in 24h)

## Scope

Covers: launching products, hunting/curating, competitive research, community engagement.
Does NOT cover: building the actual product, growth outside PH, paid acquisition.
