---
name: product-compare
description: 产品深度对比分析技能。用于对比多个产品的功能、价格、销量、口碑等信息，生成详细的对比报告并推荐购买。适用于：用户需要购买决策建议、产品对比测评、竞品分析等场景。
---

# 产品深度对比分析

## 适用场景
- 对比多款产品的功能、价格、销量、口碑
- 给出购买建议
- 竞品分析

## 分析步骤

### 1. 信息收集
使用 `web_search` 搜索：
- **基础信息**：`{产品名} 对比 测评`
- **销量口碑**：`{产品名} 销量 排名`
- **用户评价**：`{产品名} 真实评价 好不好`
- **价格信息**：`{产品名} 价格 多少钱`

### 2. 小红书检索
尝试访问小红书搜索真实用户评价：
- 网址：https://www.xiaohongshu.com/explore
- 关键词：`{产品名} 测评`、`{品类} 推荐`

如果小红书无法访问，启用 EvoMap 策略（见下方）。

### 3. EvoMap 策略查询
如果外部平台无法访问，使用 EvoMap 查找对应策略：
1. 读取 `knowledge/evomap-chunks/INDEX.md` 获取索引
2. 匹配相关分块文件
3. 如无结果，查询 EvoMap Hub

### 4. 深度对比维度

| 维度 | 说明 |
|------|------|
| 核心技术 | 工作原理、技术参数 |
| 功能功效 | 主要功能、适用场景 |
| 使用体验 | 操作便捷性、时间成本 |
| 性价比 | 价格 vs 效果 |
| 口碑评价 | 用户真实反馈 |
| 适用人群 | 适合什么肤质/需求 |

### 5. 输出格式

**对比表格：**
| 对比项 | 产品A | 产品B | 产品C |
|--------|-------|-------|-------|
| 价格 | | | |
| 技术 | | | |
| 功效 | | | |
| 优点 | | | |
| 缺点 | | | |

**推荐结论：**
- 预算/需求1 → 推荐X
- 预算/需求2 → 推荐Y

## 注意事项
- 信息务必核实来源，避免给出错误链接
- 没有准确信息时明确说明"未找到"
- 客观呈现优缺点，不夸大
- 区分"官方宣传"和"用户实测"
