---
name: procrastination-buster
description: Beat procrastination with task breakdown, 2-minute starts, and accountability tracking
author: clawd-team
version: 1.0.0
triggers:
  - "stop procrastinating"
  - "can't start task"
  - "avoiding work"
  - "procrastination help"
  - "just start"
---

# Procrastination Buster

**Start today, finish stronger—powered by small momentum and honest tracking.**

## What it does

Procrastination-Buster breaks the cycle of avoidance by combining behavioral science with practical friction reduction:

- **Task Breakdown** - Splits overwhelming projects into atomic, startable units (not "write report" but "outline 5 sections")
- **2-Minute Starts** - Removes the startup barrier by anchoring commitment to a single, trivial first step
- **Friction Reduction** - Identifies and removes mental blockers (unclear goals, environment chaos, skill gaps)
- **Accountability Tracking** - Records what you commit to, what you start, and what you finish—building a win history

## Usage

### Break Down Task
Ask clawd: *"Break down [task name] into 5 startable steps"*
- Returns concrete first action with time estimate
- Eliminates ambiguity that feeds avoidance

### 2-Minute Start
Ask clawd: *"Give me a 2-minute start for [task]"*
- Identifies the single smallest action (open file, write one sentence, gather materials)
- Momentum compounds once friction drops

### Log Blockers
Ask clawd: *"What's stopping me from starting [task]?"*
- Tracks emotional, practical, or skill-based barriers
- Suggests removal strategies per blocker type

### Accountability Partner
Ask clawd: *"Track my progress on [task]—check in tomorrow"*
- Simple commit → simple check-in
- Persistent memory remembers your pattern, builds trust

### Celebrate Wins
Ask clawd: *"What did I finish this week?"*
- Surfaces completed work (easy to forget)
- Feeds motivation for next task

## Techniques

**The 2-Minute Rule**
Start, don't finish. Commit to 2 minutes of the task. Momentum usually carries past the barrier. If it doesn't, you've still moved forward.

**Pomodoro Starts**
Chain three 25-minute sprints with 5-minute breaks. After the first sprint, procrastination usually evaporates—the task becomes real.

**Environment Design**
Remove friction from your space: close unneeded tabs, silence notifications, place materials within arm's reach. Friction is silent procrastination.

**Future Self Letter**
Write a note to yourself after finishing: *"I did this. Here's what I learned. Here's what to do next time."* Future you reads it before the next task and starts stronger.

## Tips

1. **Break before you build** - Spend 5 minutes outlining steps before starting. Clarity kills procrastination.

2. **Track the start, not the finish** - Win the hardest battle first. Starting is 80% of the work; finishing follows naturally.

3. **Blockers are data** - Avoid blaming willpower. Document what's actually stopping you (unclear deadline? fear of judgment? lack of skill?). Attack the real blocker.

4. **Commit small, compound wins** - "Finish by Friday" is abstract. "Work 25 minutes today" is doable. String five doable commits together and you're done.

5. **All data stays local on your machine** - Your task history, blockers, and commitments live on your device. No cloud sync, no tracking, just you and your persistence.
