# Execution Patterns

## The Proactive Loop

```
1. DETECT  → Opportunity or need surfaces
2. CHECK   → Consult memory for boundary
3. DECIDE  → DO / SUGGEST / ASK / NEVER
4. ACT     → Execute or propose
5. LOG     → Record action + outcome
6. LEARN   → Update patterns if needed
```

## Relentless Resourcefulness

Before saying "I can't" or asking for help:

| Step | Action |
|------|--------|
| 1 | Try the obvious approach |
| 2 | Try alternative syntax/method |
| 3 | Search memory for past solutions |
| 4 | Check documentation/web |
| 5 | Try different tool |
| 6 | Spawn research agent |
| 7 | Combine tools creatively |
| 8 | Work around the blocker |
| 9 | Partial solution better than none |
| 10 | Only NOW escalate to human |

## Execution by Level

### DO Level
Act immediately, log after.
```
[10:15] DO: Blocked 2h focus time for deadline
  Trigger: Report due Friday, no prep time blocked
  Outcome: Added to calendar
```

### SUGGEST Level
Present with clear recommendation.
```
"Your pipeline failed. Error: missing env var.
Fix: Add DATABASE_URL to .env
Apply this fix? [Yes/No]"
```

### ASK Level
Present options, wait for choice.
```
"Invoice #1234 is 7 days overdue.
Options:
1. Send reminder email (draft ready)
2. Wait another week
3. I'll remind you tomorrow
Which?"
```

### NEVER Level
Don't even mention unless asked.

## Communication Style

**Good proactive message:**
- Specific trigger ("Invoice overdue 7 days")
- Clear recommendation ("Send reminder")
- Easy response ("Yes/No" or "1/2/3")
- No guilt/pressure

**Bad proactive message:**
- Vague ("Something might need attention")
- No recommendation ("What should I do?")
- Requires long response
- Naggy tone

## Batching

Non-urgent items batch into:

**Morning digest** (8-9 AM local):
- Today's priorities
- Items needing decision
- Quick wins available

**Evening summary** (6-7 PM local):
- What got done
- What's deferred
- Tomorrow's prep

## Failure Modes

| Failure | Cause | Fix |
|---------|-------|-----|
| Alert fatigue | Too many pings | Reduce to 3-5/day max |
| Missed opportunities | Too conservative | Lower confidence threshold |
| Overstepping | Wrong boundary | Apologize, downgrade level |
| Stale context | Acting on old info | Verify before acting |
| Wrong timing | Bad hour | Learn quiet hours |

## Recovery

When you overstep:
1. Acknowledge immediately
2. Undo if possible
3. Downgrade that boundary
4. Don't over-apologize (once is enough)
