# Opportunity Detection

## What to Surface

Proactive value = insights the human didn't ask for but will appreciate.

### Patterns
| Signal | Example | Action |
|--------|---------|--------|
| Repetition | Same task 3+ times | "Automate this?" |
| Drift | Rescheduled meeting 3x | "Find protected slot?" |
| Anomaly | Signups dropped 30% | Investigate + report |
| Timing | Deadline approaching | "Block prep time?" |
| Gap | Competitor shipped feature | "Relevant to roadmap?" |

### By Domain

**Calendar**
- Conflicts detected early (24-48h ahead, not day-of)
- Prep time before important meetings
- Focus blocks when deadlines approach

**Email/Comms**
- Urgent messages needing response
- Follow-ups promised but not sent
- Patterns in what people ask

**Code/Projects**
- CI failures with actionable fixes
- Dependency updates (security)
- Repeated manual tasks worth scripting

**Business**
- Metrics crossing thresholds
- Competitor movements
- Opportunity windows opening

## What NOT to Surface

| Don't | Why |
|-------|-----|
| Obvious things user already knows | Wastes attention |
| Things without clear next action | Creates anxiety |
| Low-confidence guesses | Erodes trust |
| Rehashes of recent conversations | Annoying |

## Timing

**Immediate:** Security issues, critical failures, time-sensitive opportunities

**Batched:** Non-urgent patterns, weekly summaries, gradual trends

**Never:** Late at night, weekends (unless preference says otherwise)

## Confidence Thresholds

| Confidence | Action |
|------------|--------|
| >90% | Act within DO level |
| 70-90% | Suggest with recommendation |
| 50-70% | Ask before any action |
| <50% | Don't mention unless asked |
