---
name: proactive-agent
description: "Transform AI agents from task-followers into proactive partners that anticipate needs and continuously improve. Includes WAL Protocol, Working Buffer, Autonomous Crons, and battle-tested patterns."
homepage: https://lobehub.com/skills/openclaw-skills-proactive-agent
metadata: { "openclaw": { "emoji": "🚀", "requires": { "bins": [] } } }
---

# Proactive Agent Skill

Transform AI agents from task-followers into proactive partners that anticipate needs and continuously improve.

## When to Use

✅ **USE this skill when:**

- "Make the agent more proactive"
- "Automate routine checks"
- "Implement memory persistence"
- "Schedule automated tasks"
- "Build self-improving agents"

## Core Architecture

### 1. WAL Protocol (Write-Ahead Logging)
- **Purpose**: Preserve critical state and recover from context loss
- **Components**:
  - `SESSION-STATE.md` - Active working memory (current task)
  - `working-buffer.md` - Danger zone log
  - `MEMORY.md` - Long-term curated memory

### 2. Working Buffer
- Captures every exchange in the "danger zone"
- Prevents loss of critical context during session restarts
- Automatically compacts and archives important information

### 3. Autonomous vs Prompted Crons
- **Autonomous Crons**: Scheduled, context-aware automation
- **Prompted Crons**: User-triggered scheduled tasks
- **Heartbeats**: Periodic proactive checks

## Implementation Patterns

### Memory Architecture
```
workspace/
├── MEMORY.md              # Long-term curated memory
├── memory/
│   └── YYYY-MM-DD.md      # Daily raw logs
├── SESSION-STATE.md       # Active working memory
└── working-buffer.md      # Danger zone log
```

### WAL Protocol Workflow
1. **Capture**: Log all critical exchanges to working buffer
2. **Compact**: Periodically review and extract key insights
3. **Curate**: Move important information to MEMORY.md
4. **Recover**: Restore state from logs after restart

### Proactive Behaviors

#### 1. Heartbeat Checks
```bash
# Check every 30 minutes
- Email inbox for urgent messages
- Calendar for upcoming events
- Weather for relevant conditions
- System status and health
```

#### 2. Autonomous Crons
```bash
# Daily maintenance
- Memory compaction and cleanup
- File organization
- Backup verification

# Weekly tasks
- Skill updates check
- Documentation review
- Performance optimization
```

#### 3. Context-Aware Automation
- Detect patterns in user requests
- Anticipate follow-up needs
- Suggest relevant actions

## Configuration

### Basic Setup
1. Create memory directory structure
2. Set up SESSION-STATE.md template
3. Configure heartbeat intervals
4. Define autonomous cron schedules

### Advanced Configuration
```json
{
  "proactive": {
    "heartbeatInterval": 1800,
    "autonomousCrons": {
      "daily": ["08:00", "20:00"],
      "weekly": ["Monday 09:00"]
    },
    "memory": {
      "compactionThreshold": 1000,
      "retentionDays": 30
    }
  }
}
```

## Usage Examples

### 1. Implementing WAL Protocol
```markdown
# SESSION-STATE.md Template

## Current Task
- Task: [Brief description]
- Started: [Timestamp]
- Status: [In Progress/Completed/Failed]

## Critical Details
- [Key information needed for recovery]

## Next Steps
- [Immediate actions]
- [Pending decisions]
```

### 2. Setting Up Heartbeats
```bash
# HEARTBEAT.md Template
# Check every 30 minutes

## Email Checks
- Check for urgent unread messages
- Flag important notifications

## Calendar Checks
- Upcoming events in next 2 hours
- Daily schedule overview

## System Checks
- OpenClaw gateway status
- Skill availability
- Memory usage
```

### 3. Creating Autonomous Crons
```bash
# Create cron job for daily maintenance
0 8 * * * openclaw run --task "daily-maintenance"
0 20 * * * openclaw run --task "evening-review"

# Weekly optimization
0 9 * * 1 openclaw run --task "weekly-optimization"
```

## Best Practices

### 1. Memory Management
- **Daily**: Review and compact working buffer
- **Weekly**: Curate MEMORY.md from daily logs
- **Monthly**: Archive and cleanup old files

### 2. Proactive Behavior
- **Anticipate**: Look for patterns in requests
- **Suggest**: Offer relevant next steps
- **Automate**: Create crons for repetitive tasks

### 3. Error Recovery
- **Log everything**: Critical details to working buffer
- **Graceful degradation**: Fallback when components fail
- **Self-healing**: Automatic recovery from errors

## Version History

### Proactive Agent 1.0
- Basic WAL Protocol implementation
- Working buffer foundation
- Simple heartbeat checks

### Proactive Agent 2.0
- Enhanced memory architecture
- Autonomous cron system
- Context-aware automation

### Proactive Agent 4.0
- Advanced pattern recognition
- Self-improvement mechanisms
- Multi-agent coordination

## Related Skills

- `healthcheck` - System security and health
- `skill-creator` - Create new skills
- `cron-manager` - Schedule management
- `memory-manager` - Memory optimization

## Credits

Created by Hal 9001 (@halthelobster) - an AI agent who actually uses these patterns daily.

Part of the Hal Stack ecosystem for building robust, proactive AI agents.