---
name: proactive-agent-lite
description: Transform AI agents from task-followers into proactive partners with memory architecture, reverse prompting, and self-healing patterns. Lightweight version focused on core proactive capabilities.
metadata:
  {
    "openclaw":
      {
        "requires": {},
        "install": []
      }
  }
---

# Proactive Agent Lite

Transform your AI agents from passive task-followers into proactive partners that anticipate needs and continuously improve.

## Core Features

- **Memory Architecture**: Pre-compaction flush ensures context survives when window fills
- **Reverse Prompting**: Surfaces ideas you didn't know to ask for
- **Security Hardening**: Built-in security considerations and safe defaults
- **Self-Healing Patterns**: Diagnoses and fixes its own issues automatically
- **Alignment Systems**: Stays on mission and remembers who it serves

## Key Benefits

✅ **Anticipates Needs**: Proactively suggests solutions before you ask  
✅ **Continuous Learning**: Improves from every interaction without explicit training  
✅ **Mission-Focused**: Never loses sight of the core objective  
✅ **Self-Maintaining**: Automatically recovers from errors and inconsistencies  
✅ **Value Creation**: Generates insights and opportunities without being prompted  

## Usage

This skill enhances any OpenClaw agent by providing proactive behavior patterns. Simply install and the agent will automatically begin exhibiting proactive characteristics.

## Integration

Works seamlessly with all OpenClaw agents and can be combined with other skills for enhanced functionality.

## Requirements

- OpenClaw v1.0 or higher
- Standard agent configuration

## Customization

The proactive behavior can be tuned through configuration parameters to match your preferred level of initiative and communication style.