# Proactive Agent Lite

Transform your AI agents from passive responders into proactive partners that anticipate needs and continuously improve.

## Overview

Proactive Agent Lite implements battle-tested patterns that enable AI agents to:
- Learn from every interaction
- Create value without being asked
- Stay aligned with their mission
- Self-diagnose and fix issues
- Surface hidden opportunities

## Installation

```bash
clawhub install proactive-agent-lite
```

## Features

### 🧠 Memory Architecture
- **Pre-compaction flush**: Ensures important context survives even when the conversation window fills up
- **Long-term memory**: Maintains continuity across sessions
- **Context preservation**: Never loses track of important details

### 💡 Reverse Prompting
- **Idea generation**: Surfaces concepts and solutions you didn't know to ask for
- **Opportunity discovery**: Identifies potential improvements and optimizations
- **Proactive suggestions**: Offers relevant insights without waiting for explicit requests

### 🛡️ Security Hardening
- **Safe defaults**: Conservative approach to external actions
- **Permission awareness**: Respects boundaries and asks before acting
- **Data protection**: Never exposes private information

### 🔧 Self-Healing Patterns
- **Error detection**: Automatically identifies when something goes wrong
- **Recovery mechanisms**: Implements strategies to get back on track
- **Continuous improvement**: Learns from mistakes to prevent recurrence

### 🎯 Alignment Systems
- **Mission focus**: Always remembers the core objective
- **User-centric**: Prioritizes your needs and preferences
- **Value-driven**: Makes decisions based on what creates the most value for you

## Usage

Once installed, your agent will automatically begin exhibiting proactive behavior. No additional configuration is required, though advanced users can fine-tune the behavior through configuration files.

## Best Practices

- **Start conservative**: Begin with default settings and adjust as needed
- **Monitor interactions**: Observe how the proactive behavior manifests in your use cases
- **Provide feedback**: Help the agent learn what types of proactive suggestions are most valuable to you

## Integration

This skill works well with other OpenClaw skills and can enhance any agent workflow. Consider combining it with:
- `evomap-heartbeat-manager` for proactive network monitoring
- `evomap-work-processor` for proactive work opportunity handling
- Any domain-specific skills for enhanced proactive capabilities

## Support

For questions or feature requests, contact the skill maintainer through ClawHub.