#!/bin/bash
# Setup script for privatedeepsearch-melt
# Generates a unique secret key for your SearXNG instance

set -e

SETTINGS_FILE="docker/searxng/settings.yml"

echo "🔐 Setting up melt..."

# Generate random secret key
SECRET_KEY=$(openssl rand -hex 32)

# Replace placeholder in settings
if grep -q "CHANGE_THIS_TO_A_RANDOM_STRING" "$SETTINGS_FILE"; then
    sed -i "s/CHANGE_THIS_TO_A_RANDOM_STRING/$SECRET_KEY/" "$SETTINGS_FILE"
    echo "✅ Generated unique secret key"
else
    echo "⚠️  Secret key already configured"
fi

# Start SearXNG
echo "🚀 Starting SearXNG..."
cd docker
docker-compose up -d

echo ""
echo "✅ melt is ready at http://localhost:8888"
echo ""
echo "Install skills:"
echo "  cp -r skills/* ~/.clawdbot/skills/"
echo ""
echo "Test search:"
echo "  curl -s 'http://localhost:8888/search?q=hello&format=json' | jq '.results[:3]'"
