# Troubleshooting Guide

## SearXNG Issues

### Container Won't Start

```bash
# Check logs
docker logs searxng-private

# Common fixes:
# 1. Port conflict
docker ps -a | grep 8888
# Kill conflicting container or change port

# 2. Permission issues
chmod -R 755 ./docker/searxng
```

### No Search Results

1. **Check SearXNG health**
   ```bash
   curl http://localhost:8888/healthz
   ```

2. **Check enabled engines**
   ```bash
   curl -s "http://localhost:8888/config" | jq '[.engines[] | select(.enabled==true) | .name]'
   ```

3. **Test specific engine**
   ```bash
   curl -s "http://localhost:8888/search?q=test&engines=duckduckgo&format=json"
   ```

### Slow Searches

- Reduce enabled engines (more engines = more latency)
- Check network connectivity
- Some engines may be rate-limiting

## Deep Research Issues

### Python Dependency Errors

```bash
# Check Python version
python3 --version  # Need 3.8+

# Install dependencies
pip3 install aiohttp beautifulsoup4 --user
```

### No Content Extracted

- Site may require JavaScript (not supported)
- Site may be blocking automated requests
- Content may be behind paywall

```bash
# Test URL directly
curl -s "https://example.com" | head -100
```

### Timeout Errors

Edit `deep_research.py`:
```python
REQUEST_TIMEOUT = 30  # Increase from 20
MAX_RETRIES = 3       # Increase from 2
```

## VPN/Network Issues

### Docker Not Using VPN

Check Docker network mode:
```bash
docker inspect searxng-private --format '{{.HostConfig.NetworkMode}}'
```

For host network (uses VPN):
```yaml
# docker-compose.yml
services:
  searxng:
    network_mode: host
```

### VPN Connection Drops

Check your VPN client status and reconnect:
```bash
# Example for Mullvad
mullvad status
mullvad connect

# Example for WireGuard
wg show
sudo wg-quick up wg0
```

## Clawdbot Issues

### Skills Not Detected

```bash
# Check skill directory
ls -la ~/.clawdbot/skills/

# Verify SKILL.md exists
cat ~/.clawdbot/skills/searxng/SKILL.md

# Restart gateway
clawdbot gateway restart
```

### Built-in web_search Still Active

Ensure config is correct:
```json
{
  "tools": {
    "web": {
      "search": {
        "enabled": false
      }
    }
  }
}
```

## Common Error Messages

| Error | Cause | Solution |
|-------|-------|----------|
| `Connection refused` | SearXNG not running | `docker-compose up -d` |
| `Timeout` | Network/VPN issue | Check VPN, increase timeout |
| `No results` | All engines failed | Check engine config |
| `Permission denied` | File permissions | `chmod +x deep_research.py` |
| `Module not found` | Missing Python package | `pip3 install <package>` |

## Getting Help

1. Check SearXNG docs: https://docs.searxng.org/
2. Clawdbot docs: https://clawd.bot/docs
3. Open an issue on GitHub
