# Privacy Guide

## How This Protects You

### 1. No Search Engine Tracking
- **Without SearXNG**: Google/Bing log every search, build profiles, sell to advertisers
- **With SearXNG**: Queries distributed across privacy-respecting engines, no single entity sees all

### 2. Self-Hosted = No Logs
- SearXNG runs on YOUR machine
- No third-party sees your queries
- No account required

### 3. Google/Bing Disabled
- Pre-configured to exclude tracking engines
- Only privacy-respecting sources enabled

## Traffic Flow

```
Your Query
    │
    ▼
┌─────────────────┐
│   Clawdbot      │  (your machine)
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│    SearXNG      │  (localhost:8888)
│  Docker Container
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│  Your Network   │  (+ optional VPN)
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│  Search Engines │  (DuckDuckGo, Brave, etc.)
└─────────────────┘
```

## What Each Party Sees

| Party | Can See | Cannot See |
|-------|---------|------------|
| **Your ISP** | Traffic to search engines | Query content (HTTPS) |
| **DuckDuckGo** | Your IP*, search query | Nothing else |
| **SearXNG** | All queries | N/A (local, no logs) |

*Use a VPN to hide your IP from search engines.

## VPN Recommendations

For maximum privacy, run a VPN on your host machine. Docker containers inherit the host's network routing.

**Options:**
- Mullvad (no account, accepts crypto)
- ProtonVPN (free tier available)
- IVPN (privacy-focused)
- Self-hosted WireGuard

**Verify VPN is working:**
```bash
# Your host IP
curl -s ifconfig.me

# Docker's IP (should match if VPN is active)
docker run --rm curlimages/curl -s ifconfig.me
```

## Enabled Search Engines

| Engine | Type | Notes |
|--------|------|-------|
| DuckDuckGo | General | Privacy-focused |
| Brave Search | General | Independent index |
| Startpage | General | Google results, anonymized |
| Qwant | General | EU-based |
| Mojeek | General | Own crawler |
| Wikipedia | Knowledge | No tracking |
| GitHub | Code | Public repos |
| StackOverflow | Tech Q&A | - |
| Reddit | Discussion | - |
| arXiv | Papers | Academic |

## Disabled Engines

All Google and Bing services are disabled:
- google, google images, google news, google videos
- bing, bing images, bing news, bing videos

## Additional Privacy Tips

1. **Use a VPN** - Hides your IP from search engines
2. **Use Firefox + uBlock Origin** - Blocks trackers the browser sees
3. **Different browser profiles** - Separate identities
4. **Tor Browser** - For maximum anonymity (slower)

## Customizing Privacy Settings

Edit `docker/searxng/settings.yml`:

```yaml
engines:
  # Disable an engine
  - name: reddit
    disabled: true

  # Enable an engine
  - name: wikipedia
    disabled: false
    weight: 2.0  # Higher = more results
```

Restart after changes:
```bash
docker-compose restart
```
