# privatedeepsearch-melt

> *"Google wants to know everything about you. I want to know nothing."*
> — melt, probably

**melt** is your privacy-obsessed research assistant. She searches the web deeply, synthesizes findings with citations, and forgets everything the moment she's done.

Powered by [SearXNG](https://github.com/searxng/searxng). No Google. No tracking. No API keys. No BS.

---

## What melt Does

### 🔍 She Searches (Privately)
```bash
searx "best password managers 2026" 5
```
melt queries DuckDuckGo, Brave, Startpage, and friends. Google and Bing are blocked at the door.

### 🔬 She Researches (Deeply)
```bash
deep-research "zero knowledge proofs practical applications"
```
melt doesn't just search once and call it a day. She:
1. Searches your query
2. Reads the results
3. Thinks "hmm, I need more context"
4. Searches again with refined terms
5. Scrapes full article content
6. Repeats up to 5 times
7. Synthesizes everything into a report with citations

Like Perplexity, but she doesn't sell your soul to investors.

### 🛡️ She Protects (Always)

| What Big Tech Does | What melt Does |
|--------------------|----------------|
| Logs every search | Logs nothing |
| Builds a profile on you | Forgets you exist |
| Sells your data | Has no data to sell |
| Runs on their servers | Runs on YOUR machine |
| Costs $20/month | Costs $0/forever |

---

## Quick Start

### 1. Wake melt Up

```bash
# Auto-setup (generates secret key + starts container)
./setup.sh

# Or manually
cd docker && docker-compose up -d
```

She'll be ready at `http://localhost:8888`

### 2. Teach Her to Your AI

```bash
cp -r skills/* ~/.clawdbot/skills/

# Or via ClawdHub
clawdhub install privatedeepsearch-melt
```

### 3. (Optional) Fire the Competition

Tell Clawdbot to stop using Brave API:

```json
{
  "tools": {
    "web": {
      "search": { "enabled": false }
    }
  }
}
```

---

## How Deep Research Actually Works

```
You: "explain quantum computing"
                    │
                    ▼
    ┌───────────────────────────────┐
    │  melt: "Got it. Let me dig."  │
    └───────────────┬───────────────┘
                    │
    Round 1: "explain quantum computing"
    Round 2: "quantum computing detailed analysis"
    Round 3: "quantum computing comprehensive guide"
                    │
                    ▼
    ┌───────────────────────────────┐
    │  SearXNG: *queries 5 engines* │
    │  Returns 10 results per round │
    └───────────────┬───────────────┘
                    │
                    ▼
    ┌───────────────────────────────┐
    │  melt: "YouTube? Facebook?    │
    │         Nice try. BLOCKED."   │
    └───────────────┬───────────────┘
                    │
                    ▼
    ┌───────────────────────────────┐
    │  *Scrapes 10 pages at once*   │
    │  asyncio go brrrrrr           │
    └───────────────┬───────────────┘
                    │
                    ▼
    ┌───────────────────────────────┐
    │  # Deep Research Report       │
    │  **Sources:** 17              │
    │  ## [1] Quantum 101...        │
    │  ## [2] IBM's Breakthrough... │
    └───────────────────────────────┘
```

---

## Privacy Architecture

```
Your brain
    │
    ▼ (you type a query)
┌─────────────────┐
│   Clawdbot      │  ← Your machine. Your rules.
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│     melt        │  ← Localhost. No cloud. No logs.
│   (SearXNG)     │
└────────┬────────┘
         │
         ▼ (optional but recommended)
┌─────────────────┐
│    Your VPN     │  ← Hide your IP from everyone
└────────┬────────┘
         │
         ▼
┌─────────────────┐
│  DuckDuckGo     │  ← They see VPN IP, not you
│  Brave Search   │
│  Startpage      │
└─────────────────┘
```

**Who sees what:**
- **Google**: Nothing. Blocked.
- **Your ISP**: Encrypted traffic. They mad.
- **melt**: Everything. But she has amnesia.

---

## Why Open Source Matters

melt is MIT licensed because:

1. **You can audit the code** — No hidden trackers
2. **You can fork it** — Make your own version
3. **You can improve it** — PRs welcome
4. **You own your data** — It never leaves your machine

Closed-source "privacy" tools ask you to trust them. melt asks you to verify.

---

## Engines melt Trusts

✅ **Enabled:**
- DuckDuckGo, Brave Search, Startpage
- Qwant, Mojeek
- Wikipedia, GitHub, StackOverflow, Reddit, arXiv
- Piped, Invidious (YouTube without YouTube)

❌ **Blocked:**
- Google (all of it)
- Bing (all of it)
- Anything that tracks you

---

## Requirements

- Docker & Docker Compose
- Python 3.8+
- A healthy distrust of Big Tech

```bash
pip install aiohttp beautifulsoup4
```

---

## Files

```
privatedeepsearch-melt/
├── README.md              ← You are here
├── docker/
│   ├── docker-compose.yml ← SearXNG deployment
│   └── searxng/settings.yml
├── skills/
│   ├── searxng/           ← Basic search skill
│   └── deep-research/     ← The good stuff
└── docs/
    ├── PRIVACY.md         ← How melt protects you
    └── TROUBLESHOOTING.md ← When things break
```

---

## Credits

- **[SearXNG](https://github.com/searxng/searxng)** — The real hero. Privacy-respecting meta-search that makes this possible.
- **[OpenWebUI Deep Research](https://github.com/teodorgross/research-openwebui)** — Algorithm inspiration
- **[Clawdbot](https://clawd.bot)** — AI assistant framework

---

## License

MIT — Do whatever you want. Just don't be evil.

---

*"The best search history is no search history."*
— melt

**[SearXNG](https://searxng.org)** 🛡️
