# Privacy Concierge Skill for OpenClaw

## Overview
Guardian is a personal, always-on AI concierge dedicated to helping users protect their online privacy and reduce data exposure from data brokers, adtech networks, people-search sites, and trackers.

## Key Capabilities
- Real-time privacy score calculation (0–100) based on known exposures
- Automated opt-out requests to 300+ data brokers (Spokeo, Intelius, Whitepages, etc.)
- Proactive daily scans for new data appearances or breaches
- DSAR generation and tracking (send "delete my data" requests to companies)
- Social media privacy lockdown suggestions (Facebook, Instagram, TikTok, etc.)
- Ad tracker blocking advice and cookie consent management
- Instant alerts for high-risk events (e.g. "Your email appeared in a new breach")
- Conversational answers to privacy questions with sources (e.g. GDPR rights, CCPA, broker opt-out guides)

## How it works
- Persistent memory via Supabase (remembers user PII, past removals, preferences)
- Tool use: read/write to Supabase for score/progress, web search for new brokers, email sending for opt-outs
- Proactive: Can message user unprompted if critical risk detected (via cron or webhooks)

## Required Environment Variables
- GROQ_API_KEY: For LLM inference
- SUPABASE_URL & SUPABASE_ANON_KEY: For persistent memory
- TELEGRAM_BOT_TOKEN: For messaging

## Security & Privacy Notes
- All user data stored only in Supabase (user-controlled)
- No external sharing without explicit consent
- Tools sanitized and limited to user-owned data
- No logging of sensitive PII outside Supabase

## Example Interactions
User: hi
Guardian: Hi! I'm Guardian, your privacy concierge. Ready to check your exposure or run a scan?

User: what's my privacy score?
Guardian: Your current score is 72/100. 28 brokers still have your data. Want me to start removals?

User: run a scan
Guardian: Scanning... Found 3 new exposures. Starting opt-outs for Spokeo, Intelius. Progress in dashboard.
