---
name: printpal-3d
description: Generate 3D models for 3D printing from images or text prompts using PrintPal API. Use when the user wants to create 3D printable models, convert images to STL/GLB/OBJ files, or generate 3D assets from text descriptions. Supports text-to-image via WaveSpeed when WAVESPEED_API_KEY is configured. Works with file paths, URLs, or images pasted directly into chat.
credentials:
  - name: PRINTPAL_API_KEY
    required: true
    description: API key for PrintPal 3D generation (get from https://printpal.io/api-keys)
  - name: WAVESPEED_API_KEY
    required: false
    description: API key for text-to-image and product photo generation (get from https://wavespeed.ai/accesskey)
  - name: OPENROUTER_API_KEY
    required: false
    description: API key for SEO metadata generation (get from https://openrouter.ai/keys)
---

# PrintPal 3D Model Generator

Generate 3D models from images or text prompts for 3D printing.

## Quick Start

**From an image path or URL:**
```bash
python3 {baseDir}/scripts/generate_3d.py --image /path/to/image.png
```

**From text prompt:**
```bash
python3 {baseDir}/scripts/generate_3d.py --prompt "a cute robot toy"
```

## Installation

**Required Python packages:**
```bash
pip install printpal requests
```

**For text-to-image and SEO features:**
```bash
pip install wavespeed
```

**Configure API keys** in your OpenClaw settings (`~/.openclaw/openclaw.json` under `env`):
- `PRINTPAL_API_KEY` - required for 3D generation
- `WAVESPEED_API_KEY` - for text-to-image and product photos
- `OPENROUTER_API_KEY` - for SEO metadata generation

## Workflow

1. **Get the image:**
   - If user provides a file path → use it directly
   - If user provides a URL → download it
   - If user pastes an image → use it directly (it will be available as a file path or URL in context)
   - If user provides text → generate image via WaveSpeed first

2. **Generate 3D model:**
   - Use PrintPal API with `super` quality (768 cubed)
   - Default output format: STL
   - Save to `printpal-output/` directory in workspace

3. **Provide downloads:**
   - Start file server if needed
   - Return clickable URLs

## Default Settings

| Setting | Default | Options |
|---------|---------|---------|
| Quality | super | default, high, ultra, super, super_texture, superplus, superplus_texture |
| Format | stl | stl, glb, obj, ply, fbx |

## Scripts

### generate_3d.py

Main script for generating 3D models.

```bash
python3 scripts/generate_3d.py [OPTIONS]

Options:
  -i, --image PATH      Input image file path or URL
  -p, --prompt TEXT     Text prompt (uses WaveSpeed to generate image first)
  -q, --quality TEXT    Quality level (default: super)
  -f, --format TEXT     Output format (default: stl)
  -o, --output-dir DIR  Output directory
  --json                Output results as JSON
```

### serve_files.py

Start HTTP server for file downloads.

```bash
python3 scripts/serve_files.py [OPTIONS]

Options:
  -d, --directory DIR   Directory to serve (default: printpal-output/)
  -p, --port PORT       Port number (default: 8765)
  --host HOST           Host to bind to (default: 127.0.0.1)
  --public              Bind to 0.0.0.0 to allow network access
  --url-only            Just print URL without starting server
```

## Quality Levels

| Quality | Resolution | Credits | Est. Time |
|---------|-----------|---------|-----------|
| default | 256³ | 4 | 20 sec |
| high | 384³ | 6 | 30 sec |
| ultra | 512³ | 8 | 60 sec |
| **super** | 768³ | 20 | 3 min |
| superplus | 1024³ | 30 | 4 min |

## Output Formats

| Format | Best For |
|--------|----------|
| **STL** | 3D printing (default) |
| GLB | Web/games |
| OBJ | Universal compatibility |
| PLY | Point clouds |
| FBX | Autodesk software |

## API Keys

Required environment variables (configure in `~/.openclaw/openclaw.json` under `env`):

- `PRINTPAL_API_KEY` - Get from https://printpal.io/api-keys (required for 3D generation)
- `WAVESPEED_API_KEY` - Get from https://wavespeed.ai/accesskey (optional, for text-to-image)
- `OPENROUTER_API_KEY` - Get from https://openrouter.ai/keys (optional, for SEO generation)

## Output Directory

Default output is `printpal-output/` in the skill's workspace. Override with:
- Environment variable: `PRINTPAL_OUTPUT_DIR=/path/to/output`
- Command option: `--output-dir /path/to/output`

## Security Notes

- **File server**: The serve_files.py script defaults to localhost (127.0.0.1) for security. Use `--public` flag to expose to network.
- **Third-party packages**: Scripts import `printpal`, `wavespeed`, and `requests` packages. Review these packages before installing.
- **Downloaded content**: The skill downloads images from user-supplied URLs. Treat as untrusted input.

## Error Handling

| Error | Solution |
|-------|----------|
| WAVESPEED_API_KEY not set | Provide image directly or configure API key |
| PRINTPAL_API_KEY not set | Configure in OpenClaw settings |
| Insufficient credits | Purchase at printpal.io/buy-credits |
| Package not installed | Run `pip install printpal wavespeed` |

---

# SEO Product Listing Generator

Generate SEO-optimized metadata and product photos for selling 3D models/prints on marketplaces like Etsy, TikTok Shop, etc.

## Quick Start

```bash
python3 scripts/seo_product_photos.py \
  --image /path/to/model_photo.jpg \
  --description "A cute dragon figurine" \
  --purpose "Collectible toy for fantasy fans" \
  --audience "Fantasy enthusiasts, collectors, parents buying for kids"
```

## Workflow

1. **Input**: User provides an image of their 3D model/print + description, purpose, and target audience
2. **SEO Generation**: OpenRouter MiniMax generates optimized title, description, tags
3. **Photo Generation**: WaveSpeed nano-banana/edit creates 5 polished product photos
4. **Output**: ZIP file with metadata + photos, served via local HTTP server

## Required Environment Variables

```bash
# OpenRouter (for SEO generation)
OPENROUTER_API_KEY=your_openrouter_key

# WaveSpeed (for product photos)
WAVESPEED_API_KEY=your_wavespeed_key
```

Get OpenRouter key: https://openrouter.ai/keys
Get WaveSpeed key: https://wavespeed.ai/accesskey

## Options

| Option | Short | Description | Default |
|--------|-------|-------------|---------|
| --image | -i | Path or URL to input image | (required) |
| --description | -d | Description of the 3D model/print | (required) |
| --purpose | -p | What the item is for/its use | (required) |
| --audience | -a | Target audience/customers | (required) |
| --num-photos | -n | Number of photos to generate | 5 |
| --port | - | Download server port | 8766 |
| --json | - | Output results as JSON | false |

## Output

The script generates:
- `seo_metadata.txt` - Full metadata (title, description, tags, features, etc.)
- `product_photo_01.png` through `product_photo_05.png` - Generated product photos
- `seo_product_listing.zip` - All files packaged for download

Download URL is provided at the end (e.g., `http://hostname:8766/seo_product_listing.zip`)

## SEO Metadata Fields

The generated metadata includes:
- **title**: Full SEO title (max 140 chars, keywords included)
- **short_title**: Catchy thumbnail title (max 40 chars)
- **description**: Detailed listing description (500-1000 words)
- **tags**: 15 optimized tags for search
- **category**: Primary marketplace category
- **search_terms**: 5 high-value search terms
- **key_features**: 4 key product features
- **target_marketplace**: Recommended platform

## Example

```bash# Generate SEO listing for a custom 3D printed mug holder
python3 scripts/seo_product_photos.py \
  --image /workspace/my_mug_holder.jpg \
  --description "A custom 3D printed mug holder with dragon design" \
  --purpose "Keeps mugs organized on desk or kitchen, great gift" \
  --audience "Office workers, coffee lovers, home office enthusiasts"
```

## Troubleshooting

| Error | Solution |
|-------|----------|
| OPENROUTER_API_KEY not set | Configure in OpenClaw settings |
| Photo generation fails | Check WAVESPEED_API_KEY and credits |
| Port in use | Use `--port` to specify different port |

## Reference

For detailed API documentation, see [api-reference.md](references/api-reference.md).
