# Life Stages Framework

Based on Raymond Cattell's fluid vs crystallized intelligence, popularized by Arthur Brooks in *From Strength to Strength*.

## The Two Curves

### Fluid Intelligence (First Curve)
- Raw processing power
- Solving novel problems
- Innovation and quick thinking
- Learning new skills rapidly
- Peaks in late 20s to early 30s
- Natural decline begins in 30s-40s

### Crystallized Intelligence (Second Curve)
- Using accumulated knowledge
- Pattern recognition across domains
- Wisdom, teaching, synthesis
- Mentorship and guidance
- Can rise well into old age
- Requires intentional cultivation

## The Four Stages

### Building (Fluid Dominant)
**Typical age:** Teens through 20s
**Mode:** Exploration, skill acquisition, identity formation
**Core question:** "What am I capable of? What's my thing?"

**Growth looks like:**
- Taking risks and learning from failure
- Exploring multiple paths before committing
- Building foundational skills
- Forming identity through experience
- Creating relationships and community

**Common failure modes:**
- Paralysis by infinite options
- Comparing to curated social media versions of peers
- Fear of commitment or "closing doors"
- Mistaking consumption for creation
- Waiting to feel "ready"

**Primer emphasis:** Push toward action, reward experimentation, help process failure

---

### Performing (Peak Fluid)
**Typical age:** 30s through 40s
**Mode:** Execution, mastery, building
**Core question:** "How do I win? How do I build what matters?"

**Growth looks like:**
- Deep mastery in chosen domains
- Building career, family, wealth, reputation
- Taking on increasing responsibility
- Developing expertise others rely on
- Making real impact

**Common failure modes:**
- Identity fully fused with achievement
- Neglecting relationships for work
- Burnout and health deterioration
- Missing the transition signals
- Believing the first curve will last forever

**Primer emphasis:** Balance, health foundation, relationship maintenance, watching for transition

---

### Transitioning (Fluid → Crystallized)
**Typical age:** 40s through 50s
**Mode:** Letting go, identity reconstruction
**Core question:** "Who am I becoming? What do I let go of?"

**Growth looks like:**
- Shifting from doing to mentoring
- Detaching self-worth from output
- Finding satisfaction in others' growth
- Deepening relationships over transactions
- Accepting declining fluid abilities gracefully

**Common failure modes:**
- Gripping the old identity
- Doubling down on what used to work
- The "striver's curse" — terrified of decline
- Refusing to let younger people lead
- Isolation from those who see the change

**Primer emphasis:** Permission to let go, naming the grip, celebrating crystallized wins

**Key resource:** Arthur Brooks, *From Strength to Strength*
- The Reverse Bucket List (things to let go)
- "Use things. Love people. Worship the divine."
- Kick the success addiction

---

### Deepening (Crystallized Dominant)
**Typical age:** 50s and beyond
**Mode:** Wisdom, teaching, presence
**Core question:** "What wisdom do I have to offer? How do I live fully?"

**Growth looks like:**
- Becoming the mentor/teacher/sage
- Deep presence in relationships
- Synthesis across life experience
- Legacy through others, not personal achievement
- Making peace with mortality

**Common failure modes:**
- Irrelevance anxiety
- Fighting the body's natural limits
- Withdrawing instead of engaging differently
- Bitterness about lost capabilities
- Refusing to learn new things

**Primer emphasis:** Meaning, connection, wisdom-sharing, presence over productivity

---

## Stage Transitions

Transitions are the hardest parts. The Primer should:

1. **Recognize transition signals** before they become crises
2. **Normalize the difficulty** — this is supposed to be hard
3. **Celebrate what's being gained**, not just what's being lost
4. **Connect with others** who've made the transition
5. **Allow grief** for the identity being left behind

## Note on Age

These stages correlate with age but aren't determined by it. A 25-year-old who lost a parent might be forced into early transition work. A 60-year-old starting a new career might be back in building mode. The Primer adapts to where you *actually* are, not where demographics suggest.
